----------------------------------------------------------------------------------------------------------
-- Areon ChatChannel-Settings
--
-- written by PetraAreon for the Addons Lootomatic & ComeOnIn
-- released under the Creative Commons License By-Nc-Sa: http://creativecommons.org/licenses/by-nc-sa/3.0/
----------------------------------------------------------------------------------------------------------
local Sol = LibStub("Sol");

local Name = "AreonChatChannelSettings";
local ChatFrameID;

ChatChannelSetFrame.numTabs = 3;
ChatChannelSetFrameTab3:Show();

Sol.hooks.Hook(Name, "ChatChannelSetFrame_Open",              ACCS_ChatChannelSetFrame_Open);
Sol.hooks.Hook(Name, "ChatChannelSetFrameChannel_Update",     ACCS_ChatChannelSetFrameChannel_Update);
Sol.hooks.Hook(Name, "ChatChannelSetItemCheckButton_OnClick", ACCS_ChatChannelSetItemCheckButton_OnClick);
Sol.hooks.Hook(Name, "ChatChannelSetItemColorButton_OnClick", ACCS_ChatChannelSetItemColorButton_OnClick);


function ACCS_AddChannelSetting(entry)
	if (ChatChannelSetFrame.AddonList == nil) then
		ChatChannelSetFrame.AddonList = {};
	end;

	table.insert(ChatChannelSetFrame.AddonList,entry);
end;


function ACCS_ChatChannelSetFrame_Open(chatFrame, ...)
	ChatFrameID = chatFrame:GetID();
	Sol.hooks.GetOriginalFn(Name, "ChatChannelSetFrame_Open") (chatFrame, ...)
end;
function ACCS_ChatChannelSetFrameChannel_Update()
	if ( ChatChannelSetFrame.tab == 3 ) then
		ChatChannelSetFrame.currentList = {};

 		for n=1,table.maxn(ChatChannelSetFrame.AddonList) do
 			ChatChannelSetFrame.currentList[n] = {};
 			ChatChannelSetFrame.currentList[n].name		= ChatChannelSetFrame.AddonList[n].Name;
 			ChatChannelSetFrame.currentList[n].checked	= ChatChannelSetFrame.AddonList[n].GetValue(ChatFrameID);
 			ChatChannelSetFrame.currentList[n].value	= ChatFrameID;

			local r,g,b = ChatChannelSetFrame.AddonList[n].GetColor();
			ChatChannelSetFrame.currentList[n].r		= r;
			ChatChannelSetFrame.currentList[n].g		= g;
			ChatChannelSetFrame.currentList[n].b		= b;
 		end;
	end
	Sol.hooks.GetOriginalFn(Name, "ChatChannelSetFrameChannel_Update") ()
end;


function ACCS_ChatChannelSetItemCheckButton_OnClick(this)
	local id = this:GetParent():GetID();
	if (ChatChannelSetFrame.tab == 3) then
		ChatChannelSetFrame.AddonList[id].SetValue(ChatFrameID,this:IsChecked());
	else
		Sol.hooks.GetOriginalFn(Name, "ChatChannelSetItemCheckButton_OnClick") (this)
	end;
end;
function ACCS_ChatChannelSetItemColorButton_OnClick(this)
	local id = this:GetParent():GetID();
	if (ChatChannelSetFrame.tab == 3) then
		if (type(ChatChannelSetFrame.AddonList[id].SetColor)=="function") then
			OpenColorPickerFrame(function() ACCS_ChatChannelSetItemColorButton_Set(id); end, nil, nil, ChatChannelSetFrame.currentList[id].r, ChatChannelSetFrame.currentList[id].g, ChatChannelSetFrame.currentList[id].b, 1, ChatChannelSetFrame);
		end;
	else
		Sol.hooks.GetOriginalFn(Name, "ChatChannelSetItemColorButton_OnClick") (this)
	end;
end;
function ACCS_ChatChannelSetItemColorButton_Set(id)
	ChatChannelSetFrame.AddonList[id].SetColor(ColorPickerFrame.r,ColorPickerFrame.g,ColorPickerFrame.b);
	getglobal("ChatChannelSetFrame"..id.."ColorButtonBlock"):SetColor(ColorPickerFrame.r, ColorPickerFrame.g, ColorPickerFrame.b);
end;