----------------------------------------------------------------------------------------------------------
-- ComeOnIn
--
-- written by PetraAreon
-- released under the Creative Commons License By-Nc-Sa: http://creativecommons.org/licenses/by-nc-sa/3.0/
--
-- based upon Temeraire 1.13 by Sl4ker
--
-- Get the current version at:   http://rom.curse.com/downloads/rom-addons/details/comeonin.aspx
----------------------------------------------------------------------------------------------------------

local UpdateToggle        = false;
local InvitationQueue     = {};
local invitedPlayers      = {};
local CurrentPartyMembers =  0;
local LastInvitedName;

function ComeOnIn_OnLoad()
	local Sol = LibStub("Sol");

	ComeOnIn =
		{
		Addonname				= "ComeOnIn",
		Version					= "2.23",
		ErrMsg          		= "";
		Loaded					= false,
		Active					= false,
		Fade					= {},
		ReceiveTimer    		= 0,
		AutoShoutTimer  		= 3600,
		ComChannel				= 0,
		ChannelTimer			= 0,
		ChannelMode				= false,
		ReceivedLists =
			{
			QueueTransfer     	= {},
			BlocklistTransfer 	= {},
			},
		Defaults =
			{
			PartyShout			= "ZONE",
			PartyShoutChannel	= "",
			Monitor =
				{
				ZONE			= true,
				WHISPER			= true,
				SAY				= true,
				GUILD			= true,
				YELL			= true,
				CHANNEL			= true,
				},
			AutoStop			= true,
			AutoRaid			= true,
			AutoAssist			= true,
			AutoShout			= false,
			AutoShoutInterval	= 5,
			AutoAccept			= true,
			Minimap1			= true,
			Minimap2			= false,
			Minimap3			= false,
			Minimap4			= false,
			Manager				= false,
			ManagerPosX			= 0,
			ManagerPosY			= 0,
			Blocklist			= {},
			ReceiveToggleQueue	= true,
			ReceiveToggleBlock	= true,
			HideIncomingPopup	= true,
			Scale				= 1,
			Alpha				= 1,
			ChatFrames			= {true,true,true,true,true,true,true,true,true,true},

			Groups =
				{
					{
					["Name"] = "",
					["Size"] = 36,
					["Keyword"] = {"","","","",""},
					["UseKeyword"] = {false,false,false,false,false},
					},
				},
			CurrentGroup = 1,
			},
		};

	ComeOnInFrame:RegisterEvent("VARIABLES_LOADED");
end;

function ComeOnIn_OnUpdate(elapsedTime)
	if (ComeOnIn.Loaded==true) then
		ComeOnIn_FadeFrames(elapsedTime);
		ComeOnIn_CheckInvitation(elapsedTime);
 		ComeOnIn_CheckReceives(elapsedTime);
		ComeOnIn_AutoShout(elapsedTime);
	end;
end;

function ComeOnIn_OnEvent(event)
	if (event == "VARIABLES_LOADED") then
		if not(ComeOnIn_Settings) then
			ComeOnIn_Settings = ComeOnIn.Defaults;
		end;

		local func, err = loadfile("Interface/Addons/ComeOnIn/Locales/Languages.lua");
		if (not err) then
			dofile("Interface/Addons/ComeOnIn/Locales/Languages.lua");

			if (ComeOnIn_Settings.Language == nil) then
				ComeOnIn_Settings.Language = string.upper(string.sub(GetLanguage(),1,2));
			end;

			local func, err = loadfile("Interface/Addons/ComeOnIn/Locales/"..ComeOnIn_Settings.Language..".lua");
			if (err) then
				ComeOnIn.ErrMsg = "\n\n|cffff0000No Locales found for your language \""..ComeOnIn_Settings.Language.."\", switching to fallback \"EN\"|r";
				ComeOnIn_Settings.Language = "EN";
			end;

			dofile("Interface/Addons/ComeOnIn/Locales/"..ComeOnIn_Settings.Language..".lua");

			SLASH_ComeOnInToggle1 = "/coi";
			SLASH_ComeOnInToggle2 = "/comeonin";
			SLASH_ComeOnInToggle3 = "/ComeOnIn";
			SlashCmdList["ComeOnInToggle"] = ComeOnIn_Toggle;

			if (ComeOnIn_Settings.SavedVersion ~= ComeOnIn.Version) then
				local ComeOnIn_Convert = {false,false,false,false,false,false};

				if (ComeOnIn_Settings.PartyName  ~=nil) then ComeOnIn_Convert[1] = ComeOnIn_Settings.PartyName;   end;
				if (ComeOnIn_Settings.PartySize  ~=nil) then ComeOnIn_Convert[2] = ComeOnIn_Settings.PartySize;   end;
				if (ComeOnIn_Settings.Keywords   ~=nil) then ComeOnIn_Convert[3] = ComeOnIn_Settings.Keywords;    end;
				if (ComeOnIn_Settings.UseKeywords~=nil) then ComeOnIn_Convert[4] = ComeOnIn_Settings.UseKeywords; end;
				if (ComeOnIn_Settings.Blocklist  ~=nil) then ComeOnIn_Convert[5] = ComeOnIn_Settings.Blocklist;   end;
				if (ComeOnIn_Settings.Groups     ~=nil) then ComeOnIn_Convert[6] = ComeOnIn_Settings.Groups;      end;

				ComeOnIn_Settings              = ComeOnIn.Defaults;
				ComeOnIn_Settings.SavedVersion = ComeOnIn.Version;

				if (ComeOnIn_Convert[1]~=false) then ComeOnIn_Settings.Groups[1]["Name"]        = ComeOnIn_Convert[1]; end;
				if (ComeOnIn_Convert[2]~=false) then ComeOnIn_Settings.Groups[1]["Size"]        = ComeOnIn_Convert[2]; end;
				if (ComeOnIn_Convert[3]~=false) then ComeOnIn_Settings.Groups[1]["Keywords"]    = ComeOnIn_Convert[3]; end;
				if (ComeOnIn_Convert[4]~=false) then ComeOnIn_Settings.Groups[1]["UseKeywords"] = ComeOnIn_Convert[4]; end;
				if (ComeOnIn_Convert[5]~=false) then ComeOnIn_Settings.Blocklist                = ComeOnIn_Convert[5]; end;
				if (ComeOnIn_Convert[6]~=false) then ComeOnIn_Settings.Groups                   = ComeOnIn_Convert[6]; end;

				ComeOnIn.ErrMsg = ComeOnIn.ErrMsg.."\n\n|cff40ffc0"..ComeOnIn.Strings.SystemNewVersion.."|r";
			end;

			ComeOnInFrame_Manager:ClearAllAnchors();
			ComeOnInFrame_Manager:SetAnchor("CENTER", "CENTER", UIParent, ComeOnIn_Settings.ManagerPosX, ComeOnIn_Settings.ManagerPosY);

			ComeOnIn_SetConfigFrame();

			UIDropDownMenu_Initialize(ComeOnInFrame_Dropdown               , ComeOnIn_Menue_Main);
			UIDropDownMenu_Initialize(ComeOnInFrame_Channels               , ComeOnIn_Menue_Channels);

			UIDropDownMenu_Initialize(ComeOnInFrame_Config_SettingLanguage , ComeOnIn_LanguageDropDown);
			UIDropDownMenu_Initialize(ComeOnInFrame_Config_GroupDropdown   , ComeOnIn_Menue_Groups);
			UIDropDownMenu_Initialize(ComeOnInFrame_Config_WaitingList     , ComeOnIn_Menue_Queue);
			UIDropDownMenu_Initialize(ComeOnInFrame_Config_Blocklist       , ComeOnIn_BlocklistItems);
			UIDropDownMenu_Initialize(ComeOnInFrame_Manager_WaitingList    , ComeOnIn_Menue_Queue);
			UIDropDownMenu_Initialize(ComeOnInFrame_List_Receive_Dropdown  , ComeOnIn_Menue_Receive);
			UIDropDownMenu_Initialize(ComeOnInFrame_ChatFrameDropdown      , ComeOnIn_Menue_ChatFrameDropDown, "MENU");
			ComeOnInFrame_Config_CreditLink_Text:SetText("v"..ComeOnIn.Version..", written by PetraAreon");
			ComeOnInFrame_List_Send_Radio_Whisper:SetChecked(true);

			ComeOnInFrame_DisplayProperties_Slider_Scale:SetValue(ComeOnIn_Settings.Scale);
			ComeOnInFrame_DisplayProperties_Slider_Alpha:SetValue(ComeOnIn_Settings.Alpha);

			ComeOnIn_SetLanguage();
			ComeOnIn_DisplayElements();

			if AddonManager then
				local addon =
					{
					name = "|cff40ffc0"..ComeOnIn.Addonname.."|r",
					description = ComeOnIn.Strings.GUI_AddonManagerDescription..ComeOnIn.ErrMsg,
					category = "Leveling",
					configFrame = ComeOnInFrame_Config,
					slashCommands = SLASH_ComeOnInToggle2..", "..SLASH_ComeOnInToggle1,
					version = "|cff40ffc0v"..ComeOnIn.Version.."|r",
					author = "PetraAreon",
					icon = "Interface/Addons/ComeOnIn/Textures/mm-plain.tga",
					}
				if AddonManager.RegisterAddonTable then
					AddonManager.RegisterAddonTable(addon)
				else
					AddonManager.RegisterAddon(addon.name, addon.description, addon.icon, addon.category, addon.configFrame, addon.slashCommands, addon.miniButton, addon.onClickScript)
				end
 			else
				local message = string.gsub(ComeOnIn.ErrMsg,"\n\n","\n");
				ComeOnIn_AddChatMessage("Addon loaded: |cff40ffc0"..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."|r"..message);
 			end

			ACCS_AddChannelSetting(
				{
				Name		= ComeOnIn.Addonname,
				GetValue	= ComeOnIn_ACCS_GetChecked,
				SetValue	= ComeOnIn_ACCS_SetChecked,
				GetColor	= ComeOnIn_ACCS_GetColor,
				}
			);

			ComeOnInFrame:RegisterEvent("PARTY_MEMBER_CHANGED");
			ComeOnInFrame:RegisterEvent("PARTY_INVITE_REQUEST");
			ComeOnInFrame:RegisterEvent("CHAT_MSG_SYSTEM");
			ComeOnInFrame:RegisterEvent("CHAT_MSG_WHISPER");
			ComeOnInFrame:RegisterEvent("CHAT_MSG_SAY");
			ComeOnInFrame:RegisterEvent("CHAT_MSG_PARTY");
			ComeOnInFrame:RegisterEvent("CHAT_MSG_ZONE");
			ComeOnInFrame:RegisterEvent("CHAT_MSG_GUILD");
			ComeOnInFrame:RegisterEvent("CHAT_MSG_YELL");
			ComeOnInFrame:RegisterEvent("CHAT_MSG_CHANNEL");

			Sol.hooks.Hook(ComeOnIn.Addonname, "ChatFrame_OnEvent",        ComeOnIn_ChatFrame_OnEvent);
			Sol.hooks.Hook(ComeOnIn.Addonname, "CRF_TalkFrame_AddMessage", ComeOnIn_CRF_TalkFrame_AddMessage);
			Sol.hooks.Hook(ComeOnIn.Addonname, "Hyperlink_Assign",         ComeOnIn_Hyperlink_Assign);

			ComeOnInFrame_CreditsGuild:SetText("[Nachtschw\195\164rmer]"); -- needed to change here, no ae possible in that damned xml
			ComeOnIn.Loaded = true;
			SaveVariables("ComeOnIn_Settings");
		else
			ComeOnIn_AddChatMessage("|cff40ffc0["..ComeOnIn.Addonname.." "..ComeOnIn.Version.."]:|r Your installation is corrupted, please re-install!",0.7,0.7,0.7);
			ComeOnInFrame_Minimap:Hide();
			ComeOnInFrame_Minimap_Config:Hide();
			ComeOnInFrame_Minimap_Start:Hide();
			ComeOnInFrame_Minimap_Shout:Hide();
		end;
	elseif (ComeOnIn.Loaded) then
		-- store original eventvalues
		local _event = event;
		local _arg1  = arg1;
		local _arg2  = arg2;
		local _arg3  = arg3;
		local _arg4  = arg4;

		-- check for new versions
		if (type(arg1)=="string") then
			if (string.find(arg1,"%["..ComeOnIn.Addonname.." v[^%]]*%]")~=nil and UpdateToggle==false) then
				local Version   = string.gsub(string.gsub(arg1,"%].*$",""),"^.*%["..ComeOnIn.Addonname.." v","");
				local Found     = tonumber(Version);
				local Installed = tonumber(ComeOnIn.Version);

				if (Found > Installed) then
					UpdateToggle=true;
					ScrollBannerFrame_AddMessage(string.gsub(ComeOnIn.Strings.SystemAvailable,"<VERSION>",Version));
				end;
			end;
		end;

		-- check for sended lists
		if (type(arg1)=="string" and type(arg4)=="string" and arg4~=UnitName("player")) then
			-- new format
			if (string.find(arg1,"^|Hcomeoninlist") ~= nil) then
				local Mode    = string.gsub(arg1,"^.*|h%[([^%]]*)%]|h.*$"  ,"%1");
				local Message = string.gsub(arg1,"^.*|Hcomeoninlist:([^%|]*)|h.*$","%1");
				ComeOnIn_ReceiveList(Message,Mode,arg4);
			-- old format
			elseif (string.find(arg1,"^%[BlocklistTransfer%]") ~= nil or string.find(arg1,"^%[QueueTransfer%]") ~= nil) then
				local Mode    = string.gsub(arg1,"^%[([^%]]*)%].*$"  ,"%1");
				local Message = string.gsub(arg1,"^[^;]*;(.*);[^;]*$","%1");
				ComeOnIn_ReceiveList(Message,Mode,arg4);
			end;
		end;

		-- Doorbell-sound for Invitations
		if (event == "PARTY_INVITE_REQUEST") then
			PlaySoundByPath("Interface/Addons/ComeOnIn/Sounds/Invite.wav");
		end;

		-- Active-Only Events
		if (ComeOnIn.Active==true) then
			if (event == "PARTY_MEMBER_CHANGED" and IsPartyLeader("player") and ComeOnIn_Settings.AutoRaid==true and ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Size"]>6 and GetNumRaidMembers()==0 and GetNumPartyMembers()>=6) then
				SwitchToRaid();
				ComeOnIn_SetupManager();
			end;

			if (event == "CHAT_MSG_SYSTEM" and type(arg1)=="string") then
				    if (string.find(arg1,TEXT('SYS_PARTY_LEAVE'))~=nil and ComeOnIn_Settings.AutoStop==true) then
	 				ComeOnIn_StartOrStop("off");
				elseif (string.find(arg1,string.gsub(TEXT('SYS_ADD_PARTY'),"%[[^%]]*%]",""))~=nil) then
					ComeOnIn_RemoveFromQueue(string.gsub(arg1,"^.*%[([^%[%]]*)%].*$","%1"),true);
					if (ComeOnIn_Settings.AutoAssist == true and GetNumRaidMembers()>0) then ComeOnIn_PromoteToAssist(true); end;
				elseif (string.find(arg1,string.gsub(TEXT('SYS_PARTY_UNINVITE'),"%[[^%]]*%]","")) ~= nil) then
					ComeOnIn_CycleQueue();
				elseif (string.find(arg1,TEXT('SYS_GAMEMSGEVENT_020')) ~= nil) then
					SendChatMessage("["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]\n"..ComeOnIn.Strings.InviteInOtherParty, "WHISPER", 0, LastInvitedName);
					ComeOnIn_RemoveFromInvitations(LastInvitedName);
					ComeOnIn_CycleQueue();
				elseif (string.find(arg1,string.gsub(TEXT('SYS_DECLINE_GROUP'),"%[[^%]]*%]","")) ~= nil) then
					ComeOnIn_RemoveFromInvitations(string.gsub(arg1," .*$",""));
					ComeOnIn_CycleQueue();
				end;
			elseif (string.find(event,"^CHAT_MSG") ~= nil and type(arg1)=="string" and type(arg4)=="string") then
				if (ComeOnIn_UnitInParty(arg4) == false) then
					local message = arg1;
					-- remove links and colors from string before parsing
					message = string.gsub(arg1,"|H[^|]*|h","");
					message = string.gsub(arg1,"|h","");
					message = string.gsub(arg1,"|c........","");
					message = string.gsub(arg1,"|r","");

					if (ComeOnIn_Settings.Monitor[string.sub(event,10,string.len(event))] == true) then
						local FoundKeyword = ComeOnIn_Search(message);

						    if (FoundKeyword == true) then
							ComeOnIn_RemoveFromQueue(arg4,false);
						elseif (FoundKeyword ~= false) then
							if (ComeOnIn_UnitOnBlocklist(arg4)==0) then
								ComeOnIn_PutOnQueue(arg4,FoundKeyword);
							else
								SendChatMessage("["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]\n"..ComeOnIn.Strings.InviteBlocked, "WHISPER", 0, arg4);
								ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.SystemBlocklistRefuseInvite,"<NAME>","|Hplayer:"..arg4.."|h|cffff00ff["..arg4.."]|r|h"),0.8,0,0.8);
							end;
						end;
					end;
				end;
			end;
		end;

		-- reset to stored eventvalues
		event = _event;
		arg1  = _arg1;
		arg2  = _arg2;
		arg3  = _arg3;
		arg4  = _arg4;
	end;
end;



----------------------------------------------------------------------------------------------------
-------------------- ChatMessages Output and Setup -------------------------------------------------
----------------------------------------------------------------------------------------------------

function ComeOnIn_AddChatMessage(message,r,g,b)
	for n=1,10 do
		if (ComeOnIn_Settings.ChatFrames[n]) then
			if (r~=nil and g~=nil and b~=nil) then
				getglobal("ChatFrame"..n):AddMessage("|cff40ffc0["..ComeOnIn.Addonname.."]:|r "..message,r,g,b);
			else
				getglobal("ChatFrame"..n):AddMessage("|cff40ffc0["..ComeOnIn.Addonname.."]:|r "..message);
			end;
		end;
	end;
end;

function ComeOnIn_ACCS_GetChecked(frame)
	return ComeOnIn_Settings.ChatFrames[frame];
end;
function ComeOnIn_ACCS_SetChecked(frame,mode)
	if (type(mode)=="boolean") then
		ComeOnIn_Settings.ChatFrames[frame] = mode;
	else
		ComeOnIn_Settings.ChatFrames[frame] = true;
	end;
end;

function ComeOnIn_ACCS_GetColor()
	return 0.25,1,0.75;
end;




----- Hide poping ChatWindows when Customchannel is ComeOnIn, or Whisper starts with Addontag
function ComeOnIn_CRF_TalkFrame_AddMessage(MsnWin,who,msg)
	if (getglobal(MsnWin:GetName().."_TitleText"):GetText() == ComeOnIn.Addonname or string.find(msg,"^%["..ComeOnIn.Addonname.." v[^%]]*]")~=nil) then
		getglobal(MsnWin:GetName()):Hide();
	else
		Sol.hooks.GetOriginalFn(ComeOnIn.Addonname, "CRF_TalkFrame_AddMessage")(MsnWin,who,msg);
	end;
end;

----- Overriding Eventhandler for Chatframe
function ComeOnIn_ChatFrame_OnEvent(this, event)
	-- store original eventvalues
	local _event = event;
	local _arg1  = arg1;
	local _arg2  = arg2;
	local _arg3  = arg3;
	local _arg4  = arg4;

	-- remove channelmessages of Channel "ComeOnIn"
	if (tonumber(arg3)~=nil) then
 		if (event=="CHAT_MSG_CHANNEL" and GetChannelName(tonumber(arg3))==ComeOnIn.Addonname) then
-- 			-- do something for ai-database
 			return;
 		end;
	end;

	-- remove outgoing whispers, starting with addontag
	if (type(arg1)=="string") then
		if (event=="CHAT_MSG_WHISPER_INFORM" and string.find(arg1,"%["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."%]")~=nil) then
			return;
		end;
	end;

	-- remove incoming whispers with addontag, while Invitation-Popup is visible
	if (type(arg1)=="string" and type(arg4)=="string") then
		if (event=="CHAT_MSG_WHISPER" and string.find(arg1,"%["..ComeOnIn.Addonname.." v[^%]]*%]%+")~=nil) then
			for n=1,4 do
				if (getglobal("StaticPopup"..n):IsVisible()
				and (string.find(getglobal("StaticPopup"..n.."Text"):GetText(),string.gsub(ASK_INVITE_TO_PARTY,"%%s",arg4))~=nil
				or   string.find(getglobal("StaticPopup"..n.."Text"):GetText(),string.gsub(string.gsub(ComeOnIn.Strings.GUI_Popups_Invitations,"<ADDONNAME>",ComeOnIn.Addonname),"<NAME>",arg4))~=nil) ) then
					if (ComeOnIn_Settings.AutoAccept==true) then
						-- Automatically accept invitation sent by ComeOnIn
						AcceptGroup();
						getglobal("StaticPopup"..n):Hide();
					else
						-- write text into Invitation-Popup
						getglobal("StaticPopup"..n.."Text"):SetText(string.gsub(string.gsub(ComeOnIn.Strings.GUI_Popups_Invitations,"<ADDONNAME>",ComeOnIn.Addonname),"<NAME>",arg4).."\n"..string.gsub(arg1,"^%[[^%]]*%]. *",""));
				 		StaticPopup_Resize(getglobal("StaticPopup"..n),"PARTY_INVITE");
					end;
		 			return;
				end;
			end;
		end;
	end;

	-- automatically decline groupinvitation, when invitation has suspended
	if (type(arg1)=="string" and type(arg4)=="string") then
		if (event=="CHAT_MSG_WHISPER" and string.find(arg1,"%["..ComeOnIn.Addonname.." v[^%]]*%]%-")~=nil) then
			for n=1,4 do
				if (getglobal("StaticPopup"..n):IsVisible()
				and (string.find(getglobal("StaticPopup"..n.."Text"):GetText(),string.gsub(ASK_INVITE_TO_PARTY,"%%s",arg4))~=nil
				or   string.find(getglobal("StaticPopup"..n.."Text"):GetText(),string.gsub(string.gsub(ComeOnIn.Strings.GUI_Popups_Invitations,"<ADDONNAME>",ComeOnIn.Addonname),"<NAME>",arg4))~=nil) ) then
					DeclineGroup();
					getglobal("StaticPopup"..n):Hide();
					-- return; -- Write abortmessage into chat? or open another staticpopup? I am not sure by now...
		 		end;
			end;
		end;
	end;

	-- reset to stored eventvalues and continue with original eventhandler
	event = _event;
	arg1  = _arg1;
	arg2  = _arg2;
	arg3  = _arg3;
	arg4  = _arg4;
	Sol.hooks.GetOriginalFn(ComeOnIn.Addonname, "ChatFrame_OnEvent")(this, event);
end;

----- search chatmessage for keyword, returns:
   --   1) found keyword
   --   2) true, if player wants to be removed from queue
   --   3) false, if no keyword was found
function ComeOnIn_Search(message)
	if (message ~= nil and type(message) == "string") then
		for index,keyword in pairs(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"]) do
			if (string.len(keyword) > 1 and ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][index]) then
				if(string.find(string.lower(message),"! *"..string.lower(keyword)) ~= nil) then
					return true;
				elseif(string.find(string.lower(message),string.lower(keyword)) ~= nil) then
					return keyword;
				end;
			end;
		end;
	end;
	return false;
end;





------------------------------------------------------------------------------------
---------------------------------- DROPDOWN MENUES ---------------------------------
------------------------------------------------------------------------------------

function ComeOnIn_Menue_Main()
	if (UIDROPDOWNMENU_MENU_LEVEL == 1) then
		local menuitem = {};

		menuitem.func = ComeOnIn_StartOrStop;
		menuitem.notCheckable = 1;
		if (ComeOnIn.Active==true) then menuitem.text = "|cffff4040"..ComeOnIn.Strings.GUI_off.."|r";
		                           else menuitem.text = "|cff40ff40"..ComeOnIn.Strings.GUI_on .."|r"; end;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		menuitem.checked = nil;
		menuitem.value = 1;
		if (table.maxn(ComeOnIn_Settings.Groups)>0) then menuitem.hasArrow = 1 end;
		menuitem.func = nil;
		menuitem.text = ComeOnIn.Strings.GUI_Groups;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		menuitem.hasArrow = nil;
		menuitem.func = ComeOnIn_PartyShout;
		menuitem.text = ComeOnIn.Strings.Tooltip_ComeOnInFrame_Minimap_Shout..": |cffc0c0c0"..ComeOnIn.Strings["GUI_"..ComeOnIn_Settings.PartyShout].."|r";
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		if (IsRaidLeader(UnitName("player")) and GetNumRaidMembers() > 0) then
			menuitem.func = ComeOnIn_PromoteToAssist;
			menuitem.text = ComeOnIn.Strings.Tooltip_ComeOnInFrame_Minimap_Assist;
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		elseif (IsPartyLeader(UnitName("player")) and GetNumPartyMembers() > 0) then
			menuitem.func = function() SwitchToRaid();ComeOnIn_SetupManager(); end;
			menuitem.text = string.gsub(RAIDFRAME_SWITCHTORAID,"<[^>]*>","");
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		end;

		menuitem.func = ComeOnIn_Toggle;
		menuitem.text = ComeOnIn.Strings.Tooltip_ComeOnInFrame_Minimap_Config;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		menuitem.value = 2;
		if (table.maxn(InvitationQueue)>0) then	menuitem.hasArrow = 1; end;
		menuitem.func = nil;
		menuitem.text = ComeOnIn.Strings.GUI_Queue.."  |cffc0c0c0("..ComeOnIn_GetPlaceInQueue(table.maxn(InvitationQueue))..")|r";
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		menuitem.value = 3;
		menuitem.hasArrow = 1;
		menuitem.func = nil;
		menuitem.text = ComeOnIn.Strings.GUI_Blocklist.."  |cffc0c0c0("..table.maxn(ComeOnIn_Settings.Blocklist)..")|r";
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
	else
		    if (UIDROPDOWNMENU_MENU_VALUE == 1) then ComeOnIn_Menue_Groups();
		elseif (UIDROPDOWNMENU_MENU_VALUE == 2) then ComeOnIn_Menue_Queue();
		elseif (UIDROPDOWNMENU_MENU_VALUE == 3) then ComeOnIn_BlocklistItems(); end;
	end;
end;

function ComeOnIn_Menue_Channels()
	local channellist = {GetChannelList()};
	local menuitem = {};
	menuitem.notCheckable = 1;

	local count=0;

	for n=2,table.maxn(channellist),2 do
		if (channellist[n]~=ComeOnIn.Addonname) then
			count=count+1;
			menuitem.text = channellist[n];
			menuitem.func = function() ComeOnInFrame_Config_Custom_Box:SetText(channellist[n]); end;
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		end;
	end;

	if (count==0) then
		menuitem.isTitle = 1;
		menuitem.text = ComeOnIn.Strings.SystemChannelNoChannels;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
	end;
end;

function ComeOnIn_Menue_Groups()
	if (table.maxn(ComeOnIn_Settings.Groups)>0) then
		local menuitem = {};
		for n=1,table.maxn(ComeOnIn_Settings.Groups) do
			if (ComeOnIn_Settings.CurrentGroup==n) then menuitem.checked = 1; else menuitem.checked = nil; end;
			menuitem.func = ComeOnIn_Menue_Groups_Func;
			menuitem.text = ComeOnIn_GetGroupName(n);
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		end;
	end;
end;

function ComeOnIn_Menue_Groups_Func(button)
	if (button==nil)
		then ComeOnIn_Settings.CurrentGroup = table.maxn(ComeOnIn_Settings.Groups);
		else ComeOnIn_Settings.CurrentGroup = tonumber(button:GetID());
		end;
	ComeOnIn_SetConfigFrame();
end;

function ComeOnIn_Menue_Queue()
	local color={[true]="|cffff4040",[false]="|cff40ff40"};
	local menuitem = {};
	menuitem.notCheckable = 1;

	if (table.maxn(InvitationQueue)>0) then
		menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_ListSend.."|r";
		menuitem.func = ComeOnIn_Menue_Queue_Func;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_ListClear.."|r";
		menuitem.func = ComeOnIn_Menue_Queue_Func;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_ListRemoveInactive.."|r";
		menuitem.func = ComeOnIn_Menue_Queue_Func;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_Blocklist_Remove.."|r";
		menuitem.func = nil;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		for n=1,table.maxn(InvitationQueue) do
			menuitem.text = "   "..color[InvitationQueue[n][3]]..n..": "..InvitationQueue[n][1].."|r";
			menuitem.func = ComeOnIn_Menue_Queue_Func;
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		end;
	end;
end;

function ComeOnIn_Menue_Queue_Func(Selection)
	if     (Selection:GetID()==1) then
		ComeOnInFrame_List_Send_Title:SetText(ComeOnIn.Strings.GUI_ListReceiver_Title_Queue);
		ComeOnInFrame_List_Send_Send:SetID(1);

		if (UnitIsPlayer("target")==true and UnitName("target")~=UnitName("player")) then
			ComeOnInFrame_List_Send_Name:SetText(UnitName("target"));
		else
			ComeOnInFrame_List_Send_Name:SetText("");
		end;

		ComeOnIn_FadeFrames("ComeOnInFrame_List_Send");
	elseif (Selection:GetID()==2) then
		ComeOnIn_FadeFrames("ComeOnInFrame_Confirmation");
	elseif (Selection:GetID()==3) then
		local n=1;
		while (n<=table.maxn(InvitationQueue)) do
			if (InvitationQueue[n][3]==true) then
				table.remove(InvitationQueue,n);
			else
				n=n+1;
			end;
		end;
		ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemQueueInactive,0.8,0,0);
		ComeOnIn_SetupManager();
	else
		ComeOnIn_RemoveFromQueue(string.gsub(Selection:GetText(),"^[^:]*: (.*)|r","%1"),false);
	end;
end;

function ComeOnIn_Menue_Receive()
	ComeOnIn.ReceiveTimer=0;

	local menuitem = {};
	menuitem.notCheckable = 1;

	if (UIDROPDOWNMENU_MENU_LEVEL == 1) then
		if (table.maxn(ComeOnIn.ReceivedLists.QueueTransfer)>0) then
			menuitem.hasArrow = nil;
			menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_Queues..":|r"
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		end;

		for n=1,table.maxn(ComeOnIn.ReceivedLists.QueueTransfer) do
			menuitem.hasArrow = 1;
			menuitem.text = "  |cffd0ffd0"..ComeOnIn.ReceivedLists.QueueTransfer[n][1].."|r"
			menuitem.value = n;
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		end;

		if (table.maxn(ComeOnIn.ReceivedLists.BlocklistTransfer)>0) then
			menuitem.hasArrow = nil;
			menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_Blocklists..":|r"
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		end;

		for n=1,table.maxn(ComeOnIn.ReceivedLists.BlocklistTransfer) do
			menuitem.hasArrow = 1;
			menuitem.text = "  |cffffd0d0"..ComeOnIn.ReceivedLists.BlocklistTransfer[n][1].."|r";
			menuitem.value = n + table.maxn(ComeOnIn.ReceivedLists.QueueTransfer);
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		end;
	else
		menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_Receives_Load.."|r";
		menuitem.func = function() ComeOnIn_Menue_Receive_Load(UIDROPDOWNMENU_MENU_VALUE); end;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_Receives_Delete.."|r";
		menuitem.func = function() ComeOnIn_Menue_Receive_Delete(UIDROPDOWNMENU_MENU_VALUE); end;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		menuitem.text = "--------------------";
		menuitem.func = nil;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

		if (UIDROPDOWNMENU_MENU_VALUE <= table.maxn(ComeOnIn.ReceivedLists.QueueTransfer)) then
			for n=2,table.maxn  (ComeOnIn.ReceivedLists.QueueTransfer[UIDROPDOWNMENU_MENU_VALUE]) do
				local Item = ComeOnIn.ReceivedLists.QueueTransfer[UIDROPDOWNMENU_MENU_VALUE][n];
				local color={["1"]="|cffff4040",["0"]="|cff40ff40"};
				menuitem.text = color[string.gsub(Item,"^(.).*$","%1")]..string.gsub(Item,"^.","").."|r";
				UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
			end;
		else
			for n=2,table.maxn(ComeOnIn.ReceivedLists.BlocklistTransfer[UIDROPDOWNMENU_MENU_VALUE-table.maxn(ComeOnIn.ReceivedLists.QueueTransfer)]) do
				menuitem.text = ComeOnIn.ReceivedLists.BlocklistTransfer[UIDROPDOWNMENU_MENU_VALUE-table.maxn(ComeOnIn.ReceivedLists.QueueTransfer)][n];
				UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
			end;
		end;
	end;
end;

function ComeOnIn_Menue_Receive_Load(item)
	if (item > table.maxn(ComeOnIn.ReceivedLists.QueueTransfer)) then
		item = item-table.maxn(ComeOnIn.ReceivedLists.QueueTransfer);

		for n=2,table.maxn(ComeOnIn.ReceivedLists.BlocklistTransfer[item]) do
			table.insert(ComeOnIn_Settings.Blocklist,ComeOnIn.ReceivedLists.BlocklistTransfer[item][n]);
		end;

		table.sort(ComeOnIn_Settings.Blocklist);
		for i=1,table.maxn(ComeOnIn_Settings.Blocklist) do
			if (i<=table.maxn(ComeOnIn_Settings.Blocklist)) then
				while (ComeOnIn_Settings.Blocklist[i]==ComeOnIn_Settings.Blocklist[i+1] and i+1<=table.maxn(ComeOnIn_Settings.Blocklist)) do table.remove(ComeOnIn_Settings.Blocklist,i+1); end;
			end;
		end;

		ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.GUI_Receives_LoadedBlocklist,"<NAME>","|Hplayer:"..ComeOnIn.ReceivedLists.BlocklistTransfer[item][1].."|h|cffff00ff["..ComeOnIn.ReceivedLists.BlocklistTransfer[item][1].."]|r|h"),0.8,0,0.8);
		table.remove(ComeOnIn.ReceivedLists.BlocklistTransfer,item);
	else
		for n=2,table.maxn(ComeOnIn.ReceivedLists.QueueTransfer[item]) do
			local Name=string.gsub(ComeOnIn.ReceivedLists.QueueTransfer[item][n],"^.","");
			local State;
			if (string.gsub(ComeOnIn.ReceivedLists.QueueTransfer[item][n],"^(.).*$","%1")=="0") then State=false;
			                                                                                    else State=true; end;
			if (ComeOnIn_UnitOnQueue(Name)==0) then
				table.insert(InvitationQueue,{Name,"",State,true});
			end;
		end;

		ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.GUI_Receives_LoadedQueue,"<NAME>","|Hplayer:"..ComeOnIn.ReceivedLists.QueueTransfer[item][1].."|h|cff00ff00["..ComeOnIn.ReceivedLists.QueueTransfer[item][1].."]|r|h"),0,0.8,0);
		table.remove(ComeOnIn.ReceivedLists.QueueTransfer,item);
		ComeOnIn_SetupManager();
	end;

	CloseDropDownMenus(1);
	if (table.maxn(ComeOnIn.ReceivedLists.QueueTransfer) + table.maxn(ComeOnIn.ReceivedLists.BlocklistTransfer) > 0) then
		PlaySoundByPath("sound\\interface\\ui_dropdown_open.mp3");
		ToggleDropDownMenu(ComeOnInFrame_List_Receive_Dropdown);
	end;
end;

function ComeOnIn_Menue_Receive_Delete(item)
	if (item > table.maxn(ComeOnIn.ReceivedLists.QueueTransfer)) then
		table.remove(ComeOnIn.ReceivedLists.BlocklistTransfer,item-table.maxn(ComeOnIn.ReceivedLists.QueueTransfer));
	else
		table.remove(ComeOnIn.ReceivedLists.QueueTransfer,item);
	end;

	CloseDropDownMenus(1);
	if (table.maxn(ComeOnIn.ReceivedLists.QueueTransfer) + table.maxn(ComeOnIn.ReceivedLists.BlocklistTransfer) > 0) then
		PlaySoundByPath("sound\\interface\\ui_dropdown_open.mp3");
		ToggleDropDownMenu(ComeOnInFrame_List_Receive_Dropdown);
	end;
end;

----- override chatframe hyperlink clicks
function ComeOnIn_Hyperlink_Assign(link, key)
	Sol.hooks.GetOriginalFn(ComeOnIn.Addonname, "Hyperlink_Assign")(link,key);

	local _type, _data, _name = ParseHyperlink(link);

	if (type(_type)=="string" and key == "RBUTTON") then
		if (_type=="player") then
	  		local menuitem = {};
			menuitem.notCheckable = 1;

			if (table.maxn(InvitationQueue)>0) then
				menuitem.text = "|cff40ffc0["..ComeOnIn.Addonname.."]:|r "..ComeOnIn.Strings.GUI_Popups_SendQueue;
				menuitem.func = function() ComeOnIn_List_Send(1,_name); end;
				UIDropDownMenu_AddButton(menuitem, 1);
			end;

			if (table.maxn(ComeOnIn_Settings.Blocklist)>0) then
				menuitem.text = "|cff40ffc0["..ComeOnIn.Addonname.."]:|r "..ComeOnIn.Strings.GUI_Popups_SendBlock;
				menuitem.func = function() ComeOnIn_List_Send(2,_name); end;
				UIDropDownMenu_AddButton(menuitem, 1);
			end;

			menuitem.text = "|cff40ffc0["..ComeOnIn.Addonname.."]:|r "..ComeOnIn.Strings.GUI_Blocklist_Header;
			menuitem.func = function() ComeOnIn_BlocklistAdd(_name); end;
			UIDropDownMenu_AddButton(menuitem, 1);

			UIDropDownMenu_Refresh(ChatFrameDropDown);
		elseif (string.find(_type,"^comeonin")~=nil) then
			ComeOnInFrame_ChatFrameDropdown.type = _type;
			ComeOnInFrame_ChatFrameDropdown.mode = _name;
			ComeOnInFrame_ChatFrameDropdown.data = _data;
			PlaySoundByPath("sound\\interface\\ui_dropdown_open.mp3");
			ToggleDropDownMenu( ComeOnInFrame_ChatFrameDropdown, 1, nil, "cursor" , 0 , 0 );
		end;
	end;
end;

function ComeOnIn_Menue_ChatFrameDropDown(this)
	local menuitem = {};
	menuitem.notCheckable = 1;
	menuitem.text = "|cff40ffc0["..ComeOnIn.Addonname.."]|r";
	UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

	if (this.type == "comeonin") then
		menuitem.text = ComeOnIn.Strings.GUI_Popups_JoinGroup;
		menuitem.func = function() ExecuteMacroLine("/w "..string.gsub(this.data,";"," ["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."] ")); end;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		menuitem.text = ComeOnIn.Strings.GUI_Popups_LeaveQueue;
		menuitem.func = function() ExecuteMacroLine("/w "..string.gsub(this.data,";"," ["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."] !")); end;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
	elseif (this.type == "comeoninlist") then
		menuitem.text = ComeOnIn.Strings.GUI_Popups_LoadList;
		menuitem.func = function() ComeOnIn_ReceiveList(this.data,this.mode,ComeOnIn.Strings.GUI_Popups_ChatSelect); end;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
	end;

	menuitem.text = C_CANCEL;
	menuitem.func = function() end;
	UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
end;





------------------------------------------------------------------------------------
------------------------------- INVITATION PROCESSES -------------------------------
------------------------------------------------------------------------------------

----- Arrayindices of invitationqueue:
   --    1: Playername
   --    2: Keyword
   --    3: boolean, player received invitation
   --    4: boolean, player received whisper

-- check, if player has rights to invite into group
function ComeOnIn_HasRightsToInvite(Name)
	if (IsPartyLeader(Name) or IsRaidLeader(Name) or IsRaidAssistant(Name) or (GetNumPartyMembers() == 0 and GetNumRaidMembers() == 0) ) then return true;
	else return false; end;
end;

-- check if player is already in party
function ComeOnIn_UnitInParty(Name)
	if (Name==nil) then return false; end;
	if (UnitName("player")==Name) then return true; end;
	if (GetNumRaidMembers()>0)  then if (InRaidByName(Name)==true)  then return true; end; end;
	if (GetNumPartyMembers()>0) then if (InPartyByName(Name)==true) then return true; end; end;
	return false;
end;

-- find player on queue and return his position, or 0 if not found
function ComeOnIn_UnitOnQueue(Name)
	for n = 1,table.maxn(InvitationQueue) do if (InvitationQueue[n][1]==Name) then return n; end; end;
	return 0;
end;

-- find player on invitationlist and return his position, or 0 if not found
function ComeOnIn_UnitOnInvite(Name)
	for n = 1,table.maxn(invitedPlayers) do
		if (invitedPlayers[n][1]==Name) then return n; end;
	end;
	return 0;
end;

-- return first active player on the queue
function ComeOnIn_FindFirstOnQueue()
	for n = 1,table.maxn(InvitationQueue) do if (InvitationQueue[n][3]==false) then return n; end; end;
	return 0;
end;

-- return real position in queue (not counting inactive players)
function ComeOnIn_GetPlaceInQueue(index)
	local place=0;
	for n = 1,index do if (InvitationQueue[n][3]==false) then place=place+1; end; end;
	return place;
end;

-- process queue and invite next players
function ComeOnIn_CycleQueue()
	if (table.maxn(InvitationQueue)>0 and ComeOnIn.Active==true) then
		CurrentPartyMembers=0;
		if     (GetNumRaidMembers() >0) then CurrentPartyMembers=GetNumRaidMembers()+0;
		elseif (GetNumPartyMembers()>0) then CurrentPartyMembers=GetNumPartyMembers()+0; end;

		if (CurrentPartyMembers+table.maxn(invitedPlayers) < ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Size"]) then
			local index = ComeOnIn_FindFirstOnQueue();
			if (index~=0) then
				ComeOnIn_AddChatMessage(string.gsub(string.gsub(ComeOnIn.Strings.SystemInvite,"<NAME>","|Hplayer:"..InvitationQueue[index][1].."|h|cff00ff00["..InvitationQueue[index][1].."]|r|h"),"<KEYWORD>","\""..InvitationQueue[index][2].."\""),0,0.8,0);

				if     (InvitationQueue[index][4] == false) then SendChatMessage("["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]+\n"..string.gsub(ComeOnIn.Strings.InviteMessage,"<KEYWORD>","\""..InvitationQueue[index][2].."\""), "WHISPER", 0, InvitationQueue[index][1]); InvitationQueue[index][4] = 1;
				elseif (InvitationQueue[index][4] == true)  then SendChatMessage("["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]+\n"..ComeOnIn.Strings.InviteFromQueue, "WHISPER", 0, InvitationQueue[index][1]);
				end;

				InvitationQueue[index][3]=true;
				LastInvitedName=InvitationQueue[index][1];
				local FoundOnPosition=ComeOnIn_UnitOnInvite(InvitationQueue[index][1]);
				if (FoundOnPosition==0) then
					table.insert(invitedPlayers,{InvitationQueue[index][1],0});
				else
					invitedPlayers[FoundOnPosition][2]=0;
				end;
				InviteByName(InvitationQueue[index][1]);
			end;
		else
			for n=1, table.maxn(InvitationQueue) do
				if (InvitationQueue[n][4] == false) then
					InvitationQueue[n][4] = true;
					SendChatMessage("["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]\n"..string.gsub(ComeOnIn.Strings.InviteQueueAdd,"<POSITION>",ComeOnIn_GetPlaceInQueue(table.maxn(InvitationQueue))).."\n"..string.gsub(ComeOnIn.Strings.InviteQueueRemove,"<KEYWORD>",InvitationQueue[n][2]), "WHISPER", 0, InvitationQueue[n][1]);
					ComeOnIn_AddChatMessage(string.gsub(string.gsub(ComeOnIn.Strings.SystemInviteQueue,"<NAME>","|Hplayer:"..InvitationQueue[n][1].."|h|cffff0000["..InvitationQueue[n][1].."]|r|h"),"<KEYWORD>","\""..InvitationQueue[n][2].."\""),0.8,0,0);
				end;
			end;
		end;
		ComeOnIn_SetupManager();
	end;
end;

-- add player to queue
function ComeOnIn_PutOnQueue(Name,Message)
	if ( ComeOnIn_HasRightsToInvite("player")==true ) then
		local FoundOnPosition=ComeOnIn_UnitOnQueue(Name);
		if (FoundOnPosition==0) then
			-- player not found on queue, therefore add
			table.insert(InvitationQueue,{Name,Message,false,false});
		elseif (InvitationQueue[FoundOnPosition][3]==true) then
			-- player was inactive, reactivate
			InvitationQueue[FoundOnPosition][3]=false;
			InvitationQueue[FoundOnPosition][4]=true;
			SendChatMessage("["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]\n"..string.gsub(ComeOnIn.Strings.InviteReactivate,"<POSITION>",ComeOnIn_GetPlaceInQueue(FoundOnPosition)), "WHISPER", 0, Name);
		else
			-- player already on queue, so send him his current position
			SendChatMessage("["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]\n"..string.gsub(ComeOnIn.Strings.InviteQueueAlready,"<POSITION>",ComeOnIn_GetPlaceInQueue(FoundOnPosition)).."\n"..string.gsub(ComeOnIn.Strings.InviteQueueRemove,"<KEYWORD>",InvitationQueue[FoundOnPosition][2]), "WHISPER", 0, Name);
		end;
	else
		ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemNoRights,0.8,0,0);
	end;

	ComeOnIn_CycleQueue();
end;

-- remove player from queue
function ComeOnIn_RemoveFromQueue(Name,quiet)
	if (quiet==false) then
		ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.SystemQueueRemove,"<NAME>","|Hplayer:"..Name.."|h|cffff0000["..Name.."]|r|h"),0.8,0,0);
		SendChatMessage("["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]\n"..ComeOnIn.Strings.InviteQueueRemoved, "WHISPER", 0, Name);
	end;

	for n=1,table.maxn(InvitationQueue) do
		if (n>0 and n<=table.maxn(InvitationQueue)) then
			if (InvitationQueue[n][1]==Name) then
				table.remove(InvitationQueue,n);
				break;
			end;
		end;
	end;
	ComeOnIn_RemoveFromInvitations(Name);

	ComeOnIn_SetupManager();
end;

-- erase whole queue
function ComeOnIn_ClearQueue()
	InvitationQueue={};
	ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemQueueClear,0.8,0,0);
	ComeOnIn_SetupManager();
end;

-- remove from invitationslist
function ComeOnIn_RemoveFromInvitations(Name)
	for i = 1,table.maxn(invitedPlayers) do
		if (i>0 and i<=table.maxn(invitedPlayers)) then
			if(invitedPlayers[i][1]==Name) then
				table.remove(invitedPlayers,i);
				break;
			end;
		end;
	end;
	ComeOnIn_CycleQueue();
end;

-- process invitationlist and deactivate players that didnt respond for 15 seconds
function ComeOnIn_CheckInvitation(elapsedTime)
	for n = 1,table.maxn(invitedPlayers) do
		if (n>0 and n<=table.maxn(invitedPlayers)) then
			invitedPlayers[n][2] = invitedPlayers[n][2]+elapsedTime;
			if(invitedPlayers[n][2]>15) then
				ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.SystemInviteSuspend,"<NAME>","|Hplayer:"..invitedPlayers[n][1].."|h|cffff0000["..invitedPlayers[n][1].."]|r|h"),0.8,0,0);
				SendChatMessage("["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]-\n"..ComeOnIn.Strings.InviteTimeout,"WHISPER",0,invitedPlayers[n][1]);
				ComeOnIn_RemoveFromInvitations(invitedPlayers[n][1]);
			end;
		end;
	end;
end;





------------------------------------------------------------------------------------
----------------------------------- MANAGMENT --------------------------------------
------------------------------------------------------------------------------------

function ComeOnIn_GroupNew()
	table.insert(ComeOnIn_Settings.Groups,{["Name"] = "", ["Size"] = 36, ["Keyword"] = {"","","","",""}, ["UseKeyword"] = {false,false,false,false,false} });
	ComeOnIn_Menue_Groups_Func();
end;

function ComeOnIn_GroupRemove()
	table.remove(ComeOnIn_Settings.Groups,ComeOnIn_Settings.CurrentGroup);
	if (table.maxn(ComeOnIn_Settings.Groups) < 1) then ComeOnIn_GroupNew(); end;
	ComeOnIn_Menue_Groups_Func();
end;

function ComeOnIn_GetGroupName(index)
	if (string.len(ComeOnIn_Settings.Groups[index]["Name"])>0) then
		return ComeOnIn_Settings.Groups[index]["Name"];
	else
		for n=1,5 do
			if (ComeOnIn_Settings.Groups[index]["UseKeyword"][n]==true
			and string.len(ComeOnIn_Settings.Groups[index]["Keyword"][n])>0) then
				return ComeOnIn_Settings.Groups[index]["Keyword"][n];
			end;
		end;
		return "|cffc0c0c0"..ComeOnIn.Strings.GUI_EmptyGroup.."|r";
	end;
end;

function ComeOnIn_PromoteToAssist(quiet)
	if (GetNumRaidMembers()==0) then
		SwitchToRaid();
		ComeOnIn_SetupManager();
	elseif (IsRaidLeader("player")) then
		for raidIndex = 1, 36 do
			if (UnitExists("raid"..raidIndex)) then
				SwithRaidAssistant(UnitRaidIndex("raid"..raidIndex),true);
			end;
		end;
		if (quiet==false) then ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemPromoteAssists,0,0.8,0); end;
	else
		if (quiet==false) then ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemNoRightForAssists,0.8,0,0); end;
	end;
end;

function ComeOnIn_PartyShout()
	if (ComeOnIn.AutoShoutTimer >= 10) then
		ComeOnIn.AutoShoutTimer = 0;

		Members=0;
		if     (GetNumRaidMembers()>0)  then Members=GetNumRaidMembers()+0;
		elseif (GetNumPartyMembers()>0) then Members=GetNumPartyMembers()+0; end;

		local message="";
		local invitation="";

		for i = 1, 5 do
			if ( string.len(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][i]) > 0 and ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][i] == true ) then invitation=ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][i]; break; end;
		end;

		local Name = ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Name"];
		local Size = ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Size"];

		    if (Size<2) then
			ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemNoPartySize);
		elseif (string.len(invitation)==0) then
			ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemNoKeywords);
		else
			local pre = "|Hcomeonin:"..UnitName("player")..";"..invitation.."|h";

			if (string.len(Name)>0) then
				message = pre.."|c00000000["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]|r|h\n"..pre.."|c00000000-  |r"..string.gsub(string.gsub(ComeOnIn.Strings.PartyShout,"<KEYWORD>","|h"..pre.."|cffa0efff\""..invitation.."\"|r|h\n"..pre.."|c00000000-  |r"),"<NAME>" ,"|cff70c070"..Name.."|r");
			else
				message = pre.."|c00000000["..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."]|r|h\n"..pre.."|c00000000-  |r"..string.gsub(string.gsub(ComeOnIn.Strings.PartyShout,"<KEYWORD>","|h"..pre.."|cffa0efff\""..invitation.."\"|r|h\n"..pre.."|c00000000-  |r"),"<NAME> ","");
			end;

			    if (Members==0) then
				message = message..ComeOnIn.Strings.PartyShoutNew.."|h";
			elseif (Members>0 and Members<Size) then
				message = message..string.gsub(string.gsub(ComeOnIn.Strings.PartyShoutFree,"<FREE>","|cff70c070"..Size-Members.."|r"),"<MAX>","|cff70c070"..Size.."|r").."|h";
			elseif (Members>=Size and ComeOnIn.Active == false) then
				message = message..ComeOnIn.Strings.PartyShoutFull..ComeOnIn.Strings.PartyShoutFull1.."|h";
			elseif (Members>=Size and ComeOnIn.Active == true) then
				message = message..ComeOnIn.Strings.PartyShoutFull..string.gsub(ComeOnIn.Strings.PartyShoutFull2,"<QUEUESIZE>","|cff70c070"..ComeOnIn_GetPlaceInQueue(table.maxn(InvitationQueue)).."|r").."|h";
			end;

			if (ComeOnIn_Settings.PartyShout=="CHANNEL") then
				local channelname = ComeOnInFrame_Config_Custom_Box:GetText();
				if (channelname == ComeOnIn.Addonname) then
					ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.SystemChannelSystem,"<NAME>","|cffff0000\""..channelname.."\"|r"),0.8,0,0);
				elseif (string.len(channelname) > 0) then
					local channellist = {GetChannelList()};
					for n=1,table.maxn(channellist) do
						if (channellist[n] == channelname) then
							SendChatMessage(message,"CHANNEL",0,channellist[n-1]);
							return;
						end;
					end;
					ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.SystemChannelNotConnected,"<NAME>","|cffff0000\""..channelname.."\"|r"),0.8,0,0);
				else
					ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemChannelNoChannel,0.8,0,0);
				end;
			else
				SendChatMessage(message,ComeOnIn_Settings.PartyShout);
			end;
		end;
	else
		ComeOnIn_AddChatMessage(ComeOnIn.Strings.PartyShoutTimeout,0.8,0,0);
	end;
end;

function ComeOnIn_AutoShout(elapsedTime)
	ComeOnIn.AutoShoutTimer = ComeOnIn.AutoShoutTimer + elapsedTime;

	if (ComeOnIn.Active==true and ComeOnIn_Settings.AutoShout==true and ComeOnIn.AutoShoutTimer>=60*ComeOnIn_Settings.AutoShoutInterval
	and (IsRaidLeader("player") or (IsPartyLeader("player") and GetNumRaidMembers()==0) or (GetNumPartyMembers()==0 and GetNumRaidMembers()==0) ) )
		then
			ComeOnIn_PartyShout();
		end;
end;

function ComeOnIn_ClearAllFocuses()
	ComeOnInFrame_Config_KeyWord1:ClearFocus();
	ComeOnInFrame_Config_KeyWord2:ClearFocus();
	ComeOnInFrame_Config_KeyWord3:ClearFocus();
	ComeOnInFrame_Config_KeyWord4:ClearFocus();
	ComeOnInFrame_Config_KeyWord5:ClearFocus();
	ComeOnInFrame_Config_GroupName:ClearFocus();
	ComeOnInFrame_Config_GroupSize:ClearFocus();
	ComeOnInFrame_Config_Custom_Box:ClearFocus();
end;



------------------------------------------------------------------------------------
------------------------------------ BLOCKLIST -------------------------------------
------------------------------------------------------------------------------------

function ComeOnIn_BlocklistItems()
	local menuitem = {};
	menuitem.notCheckable = 1;

	if (table.maxn(ComeOnIn_Settings.Blocklist)>0) then
		menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_ListSend.."|r";
		menuitem.func = ComeOnIn_BlocklistOpenReceive;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
	end;

	menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_Blocklist_Add.."|r";
	menuitem.func = ComeOnIn_BlocklistDialogOpen;
	UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);

	if (table.maxn(ComeOnIn_Settings.Blocklist)>0) then
		menuitem.text = "|cffF4C800"..ComeOnIn.Strings.GUI_Blocklist_Remove.."|r";
		menuitem.func = nil;
		UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		for n=1,table.maxn(ComeOnIn_Settings.Blocklist) do
			menuitem.text = "   "..ComeOnIn_Settings.Blocklist[n];
			menuitem.func = ComeOnIn_BlocklistRemove;
			UIDropDownMenu_AddButton(menuitem,UIDROPDOWNMENU_MENU_LEVEL);
		end;
	end;
end;

function ComeOnIn_BlocklistOpenReceive()
	ComeOnInFrame_List_Send_Title:SetText(ComeOnIn.Strings.GUI_ListReceiver_Title_Block);
	ComeOnInFrame_List_Send_Send:SetID(2);

	if (UnitIsPlayer("target")==true and UnitName("target")~=UnitName("player")) then
		ComeOnInFrame_List_Send_Name:SetText(UnitName("target"));
	else
		ComeOnInFrame_List_Send_Name:SetText("");
	end;

	ComeOnIn_FadeFrames("ComeOnInFrame_List_Send");
end;

function ComeOnIn_UnitOnBlocklist(Name)
	for n=1,table.maxn(ComeOnIn_Settings.Blocklist) do
		if (n>0 and n<=table.maxn(ComeOnIn_Settings.Blocklist)) then
			if (ComeOnIn_Settings.Blocklist[n]==Name) then
				return n;
			end;
		end;
	end;
	return 0;
end;

function ComeOnIn_BlocklistRemove(button)
	local index=ComeOnIn_UnitOnBlocklist(string.gsub(button:GetText()," ",""));
	if (index~=0) then
		ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.SystemBlocklistRemove,"<NAME>","|Hplayer:"..ComeOnIn_Settings.Blocklist[index].."|h|cffff00ff["..ComeOnIn_Settings.Blocklist[index].."]|r|h"),0.8,0,0.8);
		table.remove(ComeOnIn_Settings.Blocklist,index);
		end;
end;

function ComeOnIn_BlocklistDialogOpen()
	if (UnitIsPlayer("target")==true and UnitName("target")~=UnitName("player")) then
		ComeOnInFrame_Blocklist_Name:SetText(UnitName("target"));
	else
		ComeOnInFrame_Blocklist_Name:SetText("");
	end;
	ComeOnInFrame_Config:Disable();
	ComeOnIn_FadeFrames("ComeOnInFrame_Blocklist");
end;

function ComeOnIn_BlocklistDialogClose(mode)
	ComeOnInFrame_Config:Enable();
	ComeOnIn_FadeFrames("ComeOnInFrame_Blocklist",-1);
	if (mode==true) then
		ComeOnIn_BlocklistAdd(string.gsub(ComeOnInFrame_Blocklist_Name:GetText(ComeOnInFrame_Blocklist_Name:GetText())," ",""));
	end;
end;

function ComeOnIn_BlocklistAdd(Name)
	if ( string.len(Name)>0 and Name~=UnitName("player")) then
		if (ComeOnIn_UnitOnBlocklist(Name)==0) then
			ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.SystemBlocklistAdd,"<NAME>","|Hplayer:"..Name.."|h|cffff00ff["..Name.."]|r|h"),0.8,0,0.8);
			table.insert(ComeOnIn_Settings.Blocklist,Name);
			table.sort(ComeOnIn_Settings.Blocklist);
		else
			ComeOnIn_AddChatMessage(string.gsub(ComeOnIn.Strings.SystemBlocklistIsBlocked,"<NAME>","|Hplayer:"..Name.."|h|cffff00ff["..Name.."]|r|h"),0.8,0,0.8);
		end;
	end;
end;



------------------------------------------------------------------------------------
---------------------------------- LIST TRANSFER -----------------------------------
------------------------------------------------------------------------------------

-- radiobuttongroup in listsend-frame
function ComeOnIn_ListReceiversRadio(Selection)
	if (Selection==1) then ComeOnInFrame_List_Send_Radio_Whisper:SetChecked(true); else ComeOnInFrame_List_Send_Radio_Whisper:SetChecked(false); end;
	if (Selection==2) then ComeOnInFrame_List_Send_Radio_Party  :SetChecked(true); else ComeOnInFrame_List_Send_Radio_Party  :SetChecked(false); end;
	if (Selection==3) then ComeOnInFrame_List_Send_Radio_Guild  :SetChecked(true); else ComeOnInFrame_List_Send_Radio_Guild  :SetChecked(false); end;
end;

-- send selected list on the selected channel
function ComeOnIn_List_Send_GetMode(listtype)
	local channel=nil;
	    if (ComeOnInFrame_List_Send_Radio_Whisper:IsChecked( )== true) then channel=tostring(ComeOnInFrame_List_Send_Name:GetText());
	elseif (ComeOnInFrame_List_Send_Radio_Party:IsChecked()   == true) then channel=true;
	elseif (ComeOnInFrame_List_Send_Radio_Guild:IsChecked()   == true) then channel=false;
	end;

	ComeOnIn_List_Send(listtype,channel);
end;

function ComeOnIn_List_Send(listtype,channel)
	local Messageparts={};
	local Message="";
	    if (listtype==1 and channel~=nil) then
		for n=1,table.maxn(InvitationQueue) do
			if (string.len(Message..";."..InvitationQueue[n][1]) > 210) then
				table.insert(Messageparts,Message);
				Message="";
			end;
			local State=0;
			if (InvitationQueue[n][3]==true ) then State=1; end;
			Message=Message..";"..State..InvitationQueue[n][1];
		end;
		table.insert(Messageparts,Message);

		for n=1,table.maxn(Messageparts) do
			    if (channel==true)  then SendChatMessage("|Hcomeoninlist:"..Messageparts[n].."|h[QueueTransfer]|h","PARTY");
			elseif (channel==false) then SendChatMessage("|Hcomeoninlist:"..Messageparts[n].."|h[QueueTransfer]|h","GUILD");
			                        else SendChatMessage("|Hcomeoninlist:"..Messageparts[n].."|h[QueueTransfer]|h","WHISPER",0,channel);
			end;
		end;
	elseif (listtype==2 and channel~=nil) then
		for n=1,table.maxn(ComeOnIn_Settings.Blocklist) do
			if (string.len(Message..";"..ComeOnIn_Settings.Blocklist[n]) > 210) then
				table.insert(Messageparts,Message);
				Message="";
			end;
			Message=Message..";"..ComeOnIn_Settings.Blocklist[n];
		end;
		table.insert(Messageparts,Message);

		for n=1,table.maxn(Messageparts) do
			    if (channel==true)  then SendChatMessage("|Hcomeoninlist:"..Messageparts[n].."|h[BlocklistTransfer]|h","PARTY");
			elseif (channel==false) then SendChatMessage("|Hcomeoninlist:"..Messageparts[n].."|h[BlocklistTransfer]|h","GUILD");
			                        else SendChatMessage("|Hcomeoninlist:"..Messageparts[n].."|h[BlocklistTransfer]|h","WHISPER",0,channel);
			end;
		end;
	end;
end;

-- Add received list to buffer
function ComeOnIn_ReceiveList(Message,Mode,Name)
	ComeOnIn.ReceiveTimer=0;
	PlaySoundByPath("Interface/Addons/ComeOnIn/Sounds/Receive.wav");

	local Found=nil;
	for n=1,table.maxn(ComeOnIn.ReceivedLists[Mode]) do
		if (ComeOnIn.ReceivedLists[Mode][n][1]==Name) then Found=n; break; end;
	end;

	if (Found==nil) then
		table.insert(ComeOnIn.ReceivedLists[Mode],{Name});
		Found=table.maxn(ComeOnIn.ReceivedLists[Mode]);
	end;

	for index in string.gmatch(Message, "([^;]+)") do
		table.insert(ComeOnIn.ReceivedLists[Mode][Found],index);
	end;
end;

-- check buffer and show/hide listreceive-frame
function ComeOnIn_CheckReceives(elapsedTime)
	if (ComeOnIn.ReceiveTimer<15) and
	  ((table.maxn(ComeOnIn.ReceivedLists.BlocklistTransfer)>0) or
	   (table.maxn(ComeOnIn.ReceivedLists.QueueTransfer    )>0))
	then
		if (ComeOnInFrame_List_Receive:IsVisible()==false) then
			ComeOnIn_FadeFrames("ComeOnInFrame_List_Receive",1);
		end;
	else
		ComeOnIn_FadeFrames("ComeOnInFrame_List_Receive",-1);
		ComeOnIn.ReceivedLists = { QueueTransfer = {}, BlocklistTransfer = {} };
	end;

	local counter = math.ceil(15-ComeOnIn.ReceiveTimer);
	if (counter<=0) then counter=0; end;
	ComeOnInFrame_List_Receive_Text:SetText(string.gsub(ComeOnIn.Strings.GUI_Receives_Text,"<SECONDS>",tostring(counter)));
end;





------------------------------------------------------------------------------------
---------------------------------- CONFIGURATION -----------------------------------
------------------------------------------------------------------------------------

function ComeOnIn_SliderValueChanged(Object)
	if (type(ComeOnIn_Settings)=="table") then
		if (Object:GetName()=="ComeOnInFrame_DisplayProperties_Slider_Scale") then
			if (math.abs(Object:GetValue()-1)<0.03) then Object:SetValue(1); end;
			ComeOnIn_Settings.Scale = Object:GetValue();
			ComeOnInFrame_DisplayProperties_Slider_Scale_Value:SetText(string.format("%d %%",ComeOnIn_Settings.Scale*100));
		elseif (Object:GetName()=="ComeOnInFrame_DisplayProperties_Slider_Alpha") then
			ComeOnIn_Settings.Alpha = Object:GetValue();
			ComeOnInFrame_DisplayProperties_Slider_Alpha_Value:SetText(string.format("%d %%",ComeOnIn_Settings.Alpha*100));
		end;
		ComeOnIn_DisplayElements();
	end;
end;

function ComeOnIn_ColorControl()
	if (ComeOnIn.Active == true) then
		ComeOnInFrame_Manager_Header:SetColor(0.25,1,0.25);
	else
		ComeOnInFrame_Manager_Header:SetColor(1,0.25,0.25);
	end;

	if (ComeOnIn_Settings.AutoAssist==true)	then ComeOnInFrame_Config_AutoAssist:SetAlpha(1);else ComeOnInFrame_Config_AutoAssist:SetAlpha(0.4);end;
	if (ComeOnIn_Settings.AutoRaid==true)	then ComeOnInFrame_Config_AutoRaid:SetAlpha(1);  else ComeOnInFrame_Config_AutoRaid:SetAlpha(0.4);  end;
	if (ComeOnIn_Settings.AutoStop==true)	then ComeOnInFrame_Config_AutoStop:SetAlpha(1);  else ComeOnInFrame_Config_AutoStop:SetAlpha(0.4);  end;

	if (ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][1]==true) then ComeOnInFrame_Config_KeyWord1_Text:SetAlpha(1); else ComeOnInFrame_Config_KeyWord1_Text:SetAlpha(0.4); end;
	if (ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][2]==true) then ComeOnInFrame_Config_KeyWord2_Text:SetAlpha(1); else ComeOnInFrame_Config_KeyWord2_Text:SetAlpha(0.4); end;
	if (ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][3]==true) then ComeOnInFrame_Config_KeyWord3_Text:SetAlpha(1); else ComeOnInFrame_Config_KeyWord3_Text:SetAlpha(0.4); end;
	if (ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][4]==true) then ComeOnInFrame_Config_KeyWord4_Text:SetAlpha(1); else ComeOnInFrame_Config_KeyWord4_Text:SetAlpha(0.4); end;
	if (ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][5]==true) then ComeOnInFrame_Config_KeyWord5_Text:SetAlpha(1); else ComeOnInFrame_Config_KeyWord5_Text:SetAlpha(0.4); end;

	if (ComeOnIn_Settings.Monitor.ZONE==true)	then ComeOnInFrame_Config_Zone_Text:SetAlpha(1);	else ComeOnInFrame_Config_Zone_Text:SetAlpha(0.4); end;
	if (ComeOnIn_Settings.Monitor.WHISPER==true)	then ComeOnInFrame_Config_Whisper_Text:SetAlpha(1);	else ComeOnInFrame_Config_Whisper_Text:SetAlpha(0.4); end;
	if (ComeOnIn_Settings.Monitor.SAY==true)	then ComeOnInFrame_Config_Say_Text:SetAlpha(1);	else ComeOnInFrame_Config_Say_Text:SetAlpha(0.4); end;
	if (ComeOnIn_Settings.Monitor.GUILD==true)	then ComeOnInFrame_Config_Guild_Text:SetAlpha(1);	else ComeOnInFrame_Config_Guild_Text:SetAlpha(0.4); end;
	if (ComeOnIn_Settings.Monitor.YELL==true)	then ComeOnInFrame_Config_Yell_Text:SetAlpha(1);	else ComeOnInFrame_Config_Yell_Text:SetAlpha(0.4); end;
end;

function ComeOnIn_Tooltips(Object)
	if (ComeOnIn.Strings["Tooltip_"..Object:GetName().."1"]~=nil) then
		GameTooltip:SetOwner(Object,"ANCHOR_BOTTOM",0,0);
		GameTooltip:ClearAllAnchors();
		GameTooltip:SetAnchor("TOPLEFT","BOTTOMLEFT",Object,0,0);

		GameTooltip:SetText("|cff40ffc0"..ComeOnIn.Strings["Tooltip_"..Object:GetName().."1"].."|r");
		GameTooltip:AddLine("|cffFFFFFF"..ComeOnIn.Strings["Tooltip_"..Object:GetName().."2"].."|r");
	end;
end;

function ComeOnIn_GroupTooltip(Object)
	GameTooltip:SetOwner(Object,"ANCHOR_BOTTOM",0,0);

	local Mode;
	if (ComeOnIn.Active==true) then Mode="b"; else Mode="a"; end;

	    if (Object:GetName()=="ComeOnInFrame_Minimap_Start") then
		GameTooltip:SetText("|cff40ffc0"..ComeOnIn.Addonname.." "..ComeOnIn.Strings["Tooltip_ComeOnInFrame_Minimap_Groupinfo1"..Mode].."|r");
	elseif (Object:GetName()=="ComeOnInFrame_Minimap"      ) then
		GameTooltip:SetText("|cff40ffc0"..ComeOnIn.Addonname.." v"..ComeOnIn.Version.."|r");

		if (ComeOnIn.Active == true) then GameTooltip:AddLine("   "..ComeOnIn.Strings.Tooltip_ComeOnInFrame_Minimap_Enabled ,0,1,0);
		                             else GameTooltip:AddLine("   "..ComeOnIn.Strings.Tooltip_ComeOnInFrame_Minimap_Disabled,1,0,0); end;
	end;

	GameTooltip:AddLine("   |cff30bf8f"..ComeOnIn.Strings["Tooltip_ComeOnInFrame_Minimap_Groupinfo2"].."|r "..ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Name"]);
	GameTooltip:AddLine("   |cff30bf8f"..ComeOnIn.Strings["Tooltip_ComeOnInFrame_Minimap_Groupinfo3"].."|r "..ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Size"]);

	if (ComeOnIn_Settings.PartyShout=="CHANNEL") then
		GameTooltip:AddLine("   |cff30bf8f"..ComeOnIn.Strings["Tooltip_ComeOnInFrame_Minimap_Groupinfo4"].."|r "..ComeOnIn.Strings["GUI_"..ComeOnIn_Settings.PartyShout]..": "..ComeOnIn_Settings.PartyShoutChannel);
	else
		GameTooltip:AddLine("   |cff30bf8f"..ComeOnIn.Strings["Tooltip_ComeOnInFrame_Minimap_Groupinfo4"].."|r "..ComeOnIn.Strings["GUI_"..ComeOnIn_Settings.PartyShout]);
	end;

	GameTooltip:AddLine("   |cff30bf8f"..ComeOnIn.Strings["Tooltip_ComeOnInFrame_Minimap_Groupinfo5"].."|r");

	for i = 1,5 do
		if (ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][i]==true and string.len(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][i])) then
			GameTooltip:AddLine("      "..ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][i]);
		end;
	end;
end;

function ComeOnIn_ShoutTooltip(Object)
	local Members=0;
	if     (GetNumRaidMembers()>0)  then Members=GetNumRaidMembers()+0;
	elseif (GetNumPartyMembers()>0) then Members=GetNumPartyMembers()+0; end;

	local invitation="";
	for i = 1, 5 do
		if ( string.len(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][i]) > 0 and ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][i] == true ) then invitation=ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][i]; break; end;
	end;

	local Name = ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Name"];
	local Size = ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Size"];

	    if (Size<2) then
		Message=ComeOnIn.Strings.SystemNoPartySize;
	elseif (string.len(invitation)==0) then
		Message=ComeOnIn.Strings.SystemNoKeywords;
	else
		if (string.len(Name)>0) then
			Message=string.gsub(string.gsub(ComeOnIn.Strings.PartyShout,"<KEYWORD>","|cffa0efff\""..invitation.."\"|r\n"),"<NAME>" ,"|cff70c070"..Name.."|r");
		else
			Message=string.gsub(string.gsub(ComeOnIn.Strings.PartyShout,"<KEYWORD>","|cffa0efff\""..invitation.."\"|r\n"),"<NAME> ","");
		end;

		    if (Members==0) then
			Message = Message..ComeOnIn.Strings.PartyShoutNew;
		elseif (Members>0 and Members<Size) then
			Message = Message..string.gsub(string.gsub(ComeOnIn.Strings.PartyShoutFree,"<FREE>","|cff70c070"..Size-Members.."|r"),"<MAX>","|cff70c070"..Size.."|r");
		elseif (Members>=Size) then
			Message = Message..ComeOnIn.Strings.PartyShoutFull;
			if (ComeOnIn.Active == false) then
				Message=Message.." "..ComeOnIn.Strings.PartyShoutFull1;
			else
				Message=Message..string.gsub(ComeOnIn.Strings.PartyShoutFull2,"<QUEUESIZE>","|cff70c070"..ComeOnIn_GetPlaceInQueue(table.maxn(InvitationQueue)).."|r");
			end;
		end;
	end;

	GameTooltip:SetOwner(Object,"ANCHOR_BOTTOM",0,0);
	GameTooltip:ClearAllAnchors();
	GameTooltip:SetAnchor("TOPLEFT","BOTTOMLEFT",Object,0,0);
	GameTooltip:SetText("|cff40ffc0"..ComeOnIn.Addonname.." "..ComeOnIn.Strings.Tooltip_ComeOnInFrame_Minimap_Shout..":|r");
	GameTooltip:AddLine("|cff70c070Kanal:|r "..ComeOnIn.Strings["GUI_"..ComeOnIn_Settings.PartyShout].."\n"..Message);
end;

function ComeOnIn_LanguageDropDown()
	local menuitem = {};
	for index,entry in pairs(ComeOnIn.Languages) do
		local func, err = loadfile("Interface/Addons/ComeOnIn/Locales/"..index..".lua");
		if (not err) then
			menuitem.text = entry;
			menuitem.func = ComeOnIn_SetLanguage;
			menuitem.notCheckable = 1;
			UIDropDownMenu_AddButton(menuitem);
		end;
	end;
end;

function ComeOnIn_SetLanguage(button)
	if (button ~= nil) then
		for index,entry in pairs(ComeOnIn.Languages) do
			if (entry==button:GetText()) then
				ComeOnIn_Settings.Language = index;
				local func, err = loadfile("Interface/Addons/ComeOnIn/Locales/"..ComeOnIn_Settings.Language..".lua");
				if (not err) then dofile  ("Interface/Addons/ComeOnIn/Locales/"..ComeOnIn_Settings.Language..".lua"); end;
				break;
			end;
		end;
	end;

	ComeOnInFrame_Config_Display						:SetText(ComeOnIn.Strings.GUI_Display);
	ComeOnInFrame_Config_ManageTitle					:SetText(ComeOnIn.Strings.GUI_Managing..":");
	ComeOnInFrame_Config_GroupTitle						:SetText(ComeOnIn.Strings.GUI_Groups..":");
	ComeOnInFrame_Config_KeywordTitle					:SetText(ComeOnIn.Strings.GUI_Keywords..":");
	ComeOnInFrame_Config_MonitorTitle					:SetText(ComeOnIn.Strings.GUI_Monitor..":");
	ComeOnInFrame_Config_Partyshout						:SetText(ComeOnIn.Strings.GUI_Partyshout);

	ComeOnInFrame_Config_Zone_Text						:SetText(ComeOnIn.Strings.GUI_ZONE);
	ComeOnInFrame_Config_Whisper_Text					:SetText(ComeOnIn.Strings.GUI_WHISPER);
	ComeOnInFrame_Config_Say_Text						:SetText(ComeOnIn.Strings.GUI_SAY);
	ComeOnInFrame_Config_Guild_Text						:SetText(ComeOnIn.Strings.GUI_GUILD);
	ComeOnInFrame_Config_Yell_Text						:SetText(ComeOnIn.Strings.GUI_YELL);

	ComeOnInFrame_Config_AutoStop_Text					:SetText(ComeOnIn.Strings.GUI_AutoStop);
	ComeOnInFrame_Config_AutoRaid_Text					:SetText(ComeOnIn.Strings.GUI_AutoRaid);
	ComeOnInFrame_Config_AutoAssist_Text				:SetText(ComeOnIn.Strings.GUI_AutoAssist);
	ComeOnInFrame_Config_AutoShout_Text					:SetText(ComeOnIn.Strings.GUI_AutoShout);
	ComeOnInFrame_Config_AutoAccept_Text				:SetText(ComeOnIn.Strings.GUI_AutoAccept);

	ComeOnInFrame_Config_SwitchToRaid					:SetText(ComeOnIn.Strings.GUI_SwitchToRaid);
	ComeOnInFrame_Config_PromoteToAssist				:SetText(ComeOnIn.Strings.GUI_PromoteToAssist);

	ComeOnInFrame_DisplayProperties_Header				:SetText(ComeOnIn.Strings.GUI_DisplayProperties_Header);
	ComeOnInFrame_DisplayProperties_Manager_Text		:SetText(ComeOnIn.Strings.GUI_DisplayProperties_Manager);
	ComeOnInFrame_DisplayProperties_Minimap_Main_Text	:SetText(ComeOnIn.Strings.GUI_DisplayProperties_Minimap_Main);
	ComeOnInFrame_DisplayProperties_Minimap_Config_Text	:SetText(ComeOnIn.Strings.GUI_DisplayProperties_Minimap_Config);
	ComeOnInFrame_DisplayProperties_Minimap_Start_Text	:SetText(ComeOnIn.Strings.GUI_DisplayProperties_Minimap_Start);
	ComeOnInFrame_DisplayProperties_Minimap_Shout_Text	:SetText(ComeOnIn.Strings.GUI_DisplayProperties_Minimap_Shout);
	ComeOnInFrame_DisplayProperties_Slider_Scale_Text	:SetText(ComeOnIn.Strings.GUI_DisplayProperties_Scale..":");
	ComeOnInFrame_DisplayProperties_Slider_Alpha_Text	:SetText(ComeOnIn.Strings.GUI_DisplayProperties_Alpha..":");

	ComeOnInFrame_Blocklist_Header						:SetText(ComeOnIn.Strings.GUI_Blocklist_Header);
	ComeOnInFrame_Blocklist_Commit						:SetText(ComeOnIn.Strings.GUI_Blocklist_Block);
	ComeOnInFrame_Blocklist_Cancel						:SetText(CANCEL);

	ComeOnInFrame_List_Receive_Title					:SetText(ComeOnIn.Strings.GUI_Receives_Title);

	ComeOnInFrame_List_Send_Text						:SetText(ComeOnIn.Strings.GUI_ListReceiver_Text);
	ComeOnInFrame_List_Send_Radio_Whisper_Text			:SetText(ComeOnIn.Strings.GUI_ListReceiver_Whisper..":");
	ComeOnInFrame_List_Send_Radio_Party_Text			:SetText(ComeOnIn.Strings.GUI_ListReceiver_Party);
	ComeOnInFrame_List_Send_Radio_Guild_Text			:SetText(ComeOnIn.Strings.GUI_ListReceiver_Guild);
	ComeOnInFrame_List_Send_Send						:SetText(ComeOnIn.Strings.GUI_ListReceiver_Send);
	ComeOnInFrame_List_Send_Cancel						:SetText(ComeOnIn.Strings.GUI_cancel);

	ComeOnInFrame_Confirmation_Title					:SetText(ComeOnIn.Strings.GUI_Confirmation_Title);
	ComeOnInFrame_Confirmation_Text						:SetText(ComeOnIn.Strings.GUI_Confirmation_Text);
	ComeOnInFrame_Confirmation_Yes						:SetText(ComeOnIn.Strings.GUI_yes);
	ComeOnInFrame_Confirmation_No						:SetText(ComeOnIn.Strings.GUI_no);

	UIDropDownMenu_SetText(ComeOnInFrame_Config_SettingLanguage	, ComeOnIn.Strings.GUI_Language);
	UIDropDownMenu_SetText(ComeOnInFrame_Config_WaitingList		, ComeOnIn.Strings.GUI_Queue);
	UIDropDownMenu_SetText(ComeOnInFrame_Config_Blocklist		, ComeOnIn.Strings.GUI_Blocklist);
	UIDropDownMenu_SetText(ComeOnInFrame_List_Receive_Dropdown	, ComeOnIn.Strings.GUI_Receives_Dropdown);

	if (ComeOnIn.Active==true) then ComeOnInFrame_Config_StartOrStop:SetText(ComeOnIn.Strings.GUI_off);
	                           else ComeOnInFrame_Config_StartOrStop:SetText(ComeOnIn.Strings.GUI_on); end;

	ComeOnIn_SetupManager();
end;

function ComeOnIn_SaveConfig()
	if (string.len(ComeOnInFrame_Config_AutoShoutInterval:GetText())>0)
		then ComeOnIn_Settings.AutoShoutInterval = tonumber(ComeOnInFrame_Config_AutoShoutInterval:GetText());
		else ComeOnIn_Settings.AutoShoutInterval = 2; end;
	if (ComeOnIn_Settings.AutoShoutInterval<2) then ComeOnIn_Settings.AutoShoutInterval=2; end;

	ComeOnIn_Settings.AutoAssist		= ComeOnInFrame_Config_AutoAssist:IsChecked();
	ComeOnIn_Settings.AutoRaid			= ComeOnInFrame_Config_AutoRaid  :IsChecked();
	ComeOnIn_Settings.AutoStop			= ComeOnInFrame_Config_AutoStop  :IsChecked();
	ComeOnIn_Settings.AutoShout			= ComeOnInFrame_Config_AutoShout :IsChecked();
	ComeOnIn_Settings.AutoAccept		= ComeOnInFrame_Config_AutoAccept:IsChecked();

	ComeOnIn_Settings.Manager			= ComeOnInFrame_DisplayProperties_Manager       :IsChecked();
	ComeOnIn_Settings.Minimap1			= ComeOnInFrame_DisplayProperties_Minimap_Main  :IsChecked();
	ComeOnIn_Settings.Minimap2			= ComeOnInFrame_DisplayProperties_Minimap_Config:IsChecked();
	ComeOnIn_Settings.Minimap3			= ComeOnInFrame_DisplayProperties_Minimap_Start :IsChecked();
	ComeOnIn_Settings.Minimap4			= ComeOnInFrame_DisplayProperties_Minimap_Shout :IsChecked();

	ComeOnIn_Settings.Monitor.ZONE		= ComeOnInFrame_Config_Zone   :IsChecked();
	ComeOnIn_Settings.Monitor.WHISPER 	= ComeOnInFrame_Config_Whisper:IsChecked();
	ComeOnIn_Settings.Monitor.SAY 		= ComeOnInFrame_Config_Say    :IsChecked();
	ComeOnIn_Settings.Monitor.GUILD 	= ComeOnInFrame_Config_Guild  :IsChecked();
	ComeOnIn_Settings.Monitor.YELL 		= ComeOnInFrame_Config_Yell   :IsChecked();
	ComeOnIn_Settings.Monitor.CHANNEL	= ComeOnInFrame_Config_Custom :IsChecked();

	ComeOnIn_Settings.PartyShoutChannel	= ComeOnInFrame_Config_Custom_Box:GetText();

	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Name"] = string.gsub(string.gsub(ComeOnInFrame_Config_GroupName:GetText(),"^ *","")," *$","");
	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Size"] = tonumber(ComeOnInFrame_Config_GroupSize:GetText());

	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][1] = string.gsub(string.gsub(ComeOnInFrame_Config_KeyWord1:GetText(),"^ *","")," *$","");
	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][2] = string.gsub(string.gsub(ComeOnInFrame_Config_KeyWord2:GetText(),"^ *","")," *$","");
	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][3] = string.gsub(string.gsub(ComeOnInFrame_Config_KeyWord3:GetText(),"^ *","")," *$","");
	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][4] = string.gsub(string.gsub(ComeOnInFrame_Config_KeyWord4:GetText(),"^ *","")," *$","");
	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][5] = string.gsub(string.gsub(ComeOnInFrame_Config_KeyWord5:GetText(),"^ *","")," *$","");

	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][1] = ComeOnInFrame_Config_KeyWordBox1:IsChecked();
	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][2] = ComeOnInFrame_Config_KeyWordBox2:IsChecked();
	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][3] = ComeOnInFrame_Config_KeyWordBox3:IsChecked();
	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][4] = ComeOnInFrame_Config_KeyWordBox4:IsChecked();
	ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][5] = ComeOnInFrame_Config_KeyWordBox5:IsChecked();

	UIDropDownMenu_SetText(ComeOnInFrame_Config_GroupDropdown, ComeOnIn_GetGroupName(ComeOnIn_Settings.CurrentGroup));

	ComeOnIn_DisplayElements();
	ComeOnIn_ColorControl();
end;

function ComeOnIn_SetConfigFrame()
	ComeOnInFrame_Config_AutoStop:SetChecked(ComeOnIn_Settings.AutoStop);
	ComeOnInFrame_Config_AutoRaid:SetChecked(ComeOnIn_Settings.AutoRaid);
	ComeOnInFrame_Config_AutoAssist:SetChecked(ComeOnIn_Settings.AutoAssist);
	ComeOnInFrame_Config_AutoShout:SetChecked(ComeOnIn_Settings.AutoShout);
	ComeOnInFrame_Config_AutoShoutInterval:SetText(tostring(ComeOnIn_Settings.AutoShoutInterval));
	ComeOnInFrame_Config_AutoAccept:SetChecked(ComeOnIn_Settings.AutoAccept);

	ComeOnInFrame_DisplayProperties_Manager       :SetChecked(ComeOnIn_Settings.Manager);
	ComeOnInFrame_DisplayProperties_Minimap_Main  :SetChecked(ComeOnIn_Settings.Minimap1);
	ComeOnInFrame_DisplayProperties_Minimap_Config:SetChecked(ComeOnIn_Settings.Minimap2);
	ComeOnInFrame_DisplayProperties_Minimap_Start :SetChecked(ComeOnIn_Settings.Minimap3);
	ComeOnInFrame_DisplayProperties_Minimap_Shout :SetChecked(ComeOnIn_Settings.Minimap4);

	ComeOnInFrame_Config_Zone:SetChecked(ComeOnIn_Settings.Monitor.ZONE);
	ComeOnInFrame_Config_Whisper:SetChecked(ComeOnIn_Settings.Monitor.WHISPER);
	ComeOnInFrame_Config_Say:SetChecked(ComeOnIn_Settings.Monitor.SAY);
	ComeOnInFrame_Config_Guild:SetChecked(ComeOnIn_Settings.Monitor.GUILD);
	ComeOnInFrame_Config_Yell:SetChecked(ComeOnIn_Settings.Monitor.YELL);
	ComeOnInFrame_Config_Custom:SetChecked(ComeOnIn_Settings.Monitor.CHANNEL);

	UIDropDownMenu_SetText(ComeOnInFrame_Config_GroupDropdown, ComeOnIn_GetGroupName(ComeOnIn_Settings.CurrentGroup));

	ComeOnInFrame_Config_GroupName:SetText(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Name"]);
	ComeOnInFrame_Config_GroupSize:SetText(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Size"]);

	ComeOnInFrame_Config_KeyWord1:SetText(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][1]);
	ComeOnInFrame_Config_KeyWord2:SetText(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][2]);
	ComeOnInFrame_Config_KeyWord3:SetText(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][3]);
	ComeOnInFrame_Config_KeyWord4:SetText(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][4]);
	ComeOnInFrame_Config_KeyWord5:SetText(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][5]);

	ComeOnInFrame_Config_KeyWordBox1:SetChecked(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][1]);
	ComeOnInFrame_Config_KeyWordBox2:SetChecked(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][2]);
	ComeOnInFrame_Config_KeyWordBox3:SetChecked(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][3]);
	ComeOnInFrame_Config_KeyWordBox4:SetChecked(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][4]);
	ComeOnInFrame_Config_KeyWordBox5:SetChecked(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][5]);

	if (ComeOnIn_Settings.PartyShout=="ZONE")		then ComeOnInFrame_Config_Partyshout_Zone   :SetChecked(true); end;
	if (ComeOnIn_Settings.PartyShout=="WHISPER")	then ComeOnInFrame_Config_Partyshout_Whisper:SetChecked(true); end;
	if (ComeOnIn_Settings.PartyShout=="SAY")		then ComeOnInFrame_Config_Partyshout_Say    :SetChecked(true); end;
	if (ComeOnIn_Settings.PartyShout=="GUILD")		then ComeOnInFrame_Config_Partyshout_Guild  :SetChecked(true); end;
	if (ComeOnIn_Settings.PartyShout=="YELL")		then ComeOnInFrame_Config_Partyshout_Yell   :SetChecked(true); end;
	if (ComeOnIn_Settings.PartyShout=="CHANNEL")	then ComeOnInFrame_Config_Partyshout_Custom :SetChecked(true); end;

	ComeOnInFrame_Config_Custom_Box:SetText(ComeOnIn_Settings.PartyShoutChannel);

	ComeOnIn_DisplayElements();
	ComeOnIn_ColorControl();
end;

function ComeOnIn_PartyShoutSelection(Object)
	if (Object==1) then ComeOnIn_Settings.PartyShout="SAY";     ComeOnInFrame_Config_Partyshout_Say   :SetChecked(true); else ComeOnInFrame_Config_Partyshout_Say   :SetChecked(false); end;
	if (Object==2) then ComeOnIn_Settings.PartyShout="ZONE";    ComeOnInFrame_Config_Partyshout_Zone  :SetChecked(true); else ComeOnInFrame_Config_Partyshout_Zone  :SetChecked(false); end;
	if (Object==3) then ComeOnIn_Settings.PartyShout="GUILD";   ComeOnInFrame_Config_Partyshout_Guild :SetChecked(true); else ComeOnInFrame_Config_Partyshout_Guild :SetChecked(false); end;
	if (Object==4) then ComeOnIn_Settings.PartyShout="YELL";    ComeOnInFrame_Config_Partyshout_Yell  :SetChecked(true); else ComeOnInFrame_Config_Partyshout_Yell  :SetChecked(false); end;
	if (Object==5) then ComeOnIn_Settings.PartyShout="CHANNEL"; ComeOnInFrame_Config_Partyshout_Custom:SetChecked(true); else ComeOnInFrame_Config_Partyshout_Custom:SetChecked(false); end;
end;




function ComeOnIn_SetupManager()
	ComeOnInFrame_Manager_Header:SetText	(ComeOnIn.Strings.GUI_Manager_Title);
	ComeOnInFrame_Manager_Config:SetText	(ComeOnIn.Strings.GUI_Manager_config);
	ComeOnInFrame_Manager_Partyshout:SetText(ComeOnIn.Strings.GUI_Partyshout);

	UIDropDownMenu_SetText(ComeOnInFrame_Manager_WaitingList, ComeOnIn.Strings.GUI_Queue);

	if (ComeOnIn.Active==true) then ComeOnInFrame_Manager_StartStop:SetText(ComeOnIn.Strings.GUI_Manager_off);
	                           else ComeOnInFrame_Manager_StartStop:SetText(ComeOnIn.Strings.GUI_Manager_on); end;

	if (GetNumRaidMembers()>0) then ComeOnInFrame_Manager_RaidAssist:SetText(ComeOnIn.Strings.GUI_PromoteToAssist);
	                           else ComeOnInFrame_Manager_RaidAssist:SetText(ComeOnIn.Strings.GUI_SwitchToRaid); end;

	if (table.maxn(InvitationQueue)>0) then ComeOnInFrame_Manager_WaitingList:Show();
	                                   else ComeOnInFrame_Manager_WaitingList:Hide(); end;
end;

function ComeOnIn_DisplayElements()
	if (ComeOnIn_Settings.Manager  == true) then ComeOnInFrame_Manager       :Show(); else ComeOnInFrame_Manager       :Hide(); end;
	if (ComeOnIn_Settings.Minimap1 == true) then ComeOnInFrame_Minimap       :Show(); else ComeOnInFrame_Minimap       :Hide(); end;
	if (ComeOnIn_Settings.Minimap2 == true) then ComeOnInFrame_Minimap_Config:Show(); else ComeOnInFrame_Minimap_Config:Hide(); end;
	if (ComeOnIn_Settings.Minimap3 == true) then ComeOnInFrame_Minimap_Start :Show(); else ComeOnInFrame_Minimap_Start :Hide(); end;
	if (ComeOnIn_Settings.Minimap4 == true) then ComeOnInFrame_Minimap_Shout :Show(); else ComeOnInFrame_Minimap_Shout :Hide(); end;

	if (type(ComeOnIn_Settings.Scale)=="number") then ComeOnInFrame_Config:SetScale(ComeOnIn_Settings.Scale); end;
	if (type(ComeOnIn_Settings.Alpha)=="number") then ComeOnInFrame_Config:SetAlpha(ComeOnIn_Settings.Alpha); end;
end;





function ComeOnIn_StartOrStop(mode)
	    if (mode == "off")	then ComeOnIn.Active = false;
	elseif (mode == "on")	then ComeOnIn.Active = true;
	else                         ComeOnIn.Active = not ComeOnIn.Active;
	end;

	if (ComeOnIn.Active == true ) then
		ComeOnInFrame_Minimap_Start_Icon:SetFile("Interface/AddOns/ComeOnIn/Textures/mm-start.tga");
		ComeOnIn_SetLanguage();
		local Message="";
		for i = 1,5 do if (ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["UseKeyword"][i]==true and string.len(ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][i])) then Message=Message.." \""..ComeOnIn_Settings.Groups[ComeOnIn_Settings.CurrentGroup]["Keyword"][i].."\""; end; end;
		ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemStart,0.25,1,0.75);
		ComeOnIn_AddChatMessage("   "..ComeOnIn.Strings.GUI_Keywords.."|cffa0efff"..Message.."|r",0.25,1,0.75);

		for n=1,ComeOnIn_GetPlaceInQueue(table.maxn(InvitationQueue)) do ComeOnIn_CycleQueue(); end;
	else
		ComeOnInFrame_Minimap_Start_Icon:SetFile("Interface/AddOns/ComeOnIn/Textures/mm-stop.tga");
		ComeOnIn_SetLanguage();
		ComeOnIn_AddChatMessage(ComeOnIn.Strings.SystemStop,0.25,1,0.75);
	end;
	ComeOnIn_ColorControl();
end;

function ComeOnIn_Toggle(box,msg)
	if (ComeOnIn.Loaded) then
		if (msg ~= nil) then
			if (string.len(msg)>0) then
				msg = string.lower(msg);
				if     ((msg == "off") or (msg == "disable"))	then ComeOnIn_StartOrStop("off");
				elseif ((msg == "on")  or (msg == "enable"))	then ComeOnIn_StartOrStop("on"); end;
			else
				ComeOnIn_FadeFrames("ComeOnInFrame_Config");
				ComeOnIn_ClearAllFocuses();
			end;
		else
			ComeOnIn_FadeFrames("ComeOnInFrame_Config");
			ComeOnIn_ClearAllFocuses();
		end;
	end;
end;

function ComeOnIn_FadeFrames(value,force)
	if (type(value)=="number") then
		for n=1,table.maxn(ComeOnIn.Fade) do
			if (ComeOnIn.Fade[n]~=nil) then
				-- iterate value
				ComeOnIn.Fade[n][2]=ComeOnIn.Fade[n][2]+ComeOnIn.Fade[n][3]*value*4;

				-- declare max/min values
				local Alpha=1;
				local Scale=1;
				if (ComeOnIn.Fade[n][1]=="ComeOnInFrame_Config") then
					Alpha=ComeOnIn_Settings.Alpha;
					Scale=ComeOnIn_Settings.Scale;
				end;

				-- check for max/min
				local complete=false;
				if (ComeOnIn.Fade[n][2]>=1 and ComeOnIn.Fade[n][3]== 1) then ComeOnIn.Fade[n][2]=1; complete=true; end;
				if (ComeOnIn.Fade[n][2]<=0 and ComeOnIn.Fade[n][3]==-1) then ComeOnIn.Fade[n][2]=0; complete=true; end;

				-- set scale/alpha
				getglobal(ComeOnIn.Fade[n][1]):SetAlpha((ComeOnIn.Fade[n][2]        )*Alpha);
				getglobal(ComeOnIn.Fade[n][1]):SetScale((ComeOnIn.Fade[n][2]*0.1+0.9)*Scale);

				-- set visibility
				if (getglobal(ComeOnIn.Fade[n][1]):GetAlpha()>0) then
					getglobal(ComeOnIn.Fade[n][1]):Show();
				else
					getglobal(ComeOnIn.Fade[n][1]):Hide();
					-- Reset values after hiding window, to prevent showing faded frames through addonmanager
					getglobal(ComeOnIn.Fade[n][1]):SetAlpha(Alpha);
					getglobal(ComeOnIn.Fade[n][1]):SetScale(Scale);
				end;

				-- remove completed frame
				if (complete) then table.remove(ComeOnIn.Fade,n); n=n-1; end;
			end;
		end;
	elseif (type(value)=="string") then
		local i,j;
		if (getglobal(value):IsVisible()) then
			i=1; j=-1;
		else
			i=0; j= 1;
		end;

		for n=1,table.maxn(ComeOnIn.Fade) do
			if (value==ComeOnIn.Fade[n][1]) then
				i= ComeOnIn.Fade[n][2];
				j=-ComeOnIn.Fade[n][3];
				table.remove(ComeOnIn.Fade,n);
				break;
			end;
		end;

		if (force~=nil) then j=force; end;

		table.insert(ComeOnIn.Fade,{value,i,j});
	end;
end;