--[[
Handles the MiniAddons bar
--]]

local Sol = LibStub("Sol")

AddonManager.AddNewMiniIcon = function(addon)
    local miniButton = addon.miniButton
    
    if not Sol.util.IsValidFrame(miniButton) then
    	addon.miniButton = nil
        return
    end
    miniButton.addon = addon
    
    miniButton:ClearAllAnchors()
    --miniButton:SetParent(AddonManagerMiniFrame)  -- 'crashes' game on exit
    miniButton:SetAnchor("LEFT", "LEFT", AddonManagerMiniFrame, AddonManagerMiniFrame:GetWidth() - 4, 0)
    
    if not Sol.table.Contains(AddonManager_UncheckedAddons, addon.name) then
        miniButton:Show()
        AddonManagerMiniFrame:SetWidth(AddonManagerMiniFrame:GetWidth() + miniButton:GetWidth())
    else
        miniButton:Hide()
    end
        
    AddonManager.ShowOrHideMiniBar(AddonManager_Settings.ShowMiniBar)
end

AddonManager.HideMiniButton = function(addon)
    local miniButton = addon.miniButton
    if not miniButton then 
        return
    end
    
    local width = miniButton:GetWidth()
    local xPos = miniButton:GetPos()
    miniButton:Hide()
    AddonManagerMiniFrame:SetWidth(AddonManagerMiniFrame:GetWidth() - width)
    
    for i, ad in ipairs(AddonManager.Addons) do
        if ad.miniButton and ad.miniButton:GetPos() > xPos then
            local pnt, relPnt, frame, x, y = ad.miniButton:GetAnchor()
            ad.miniButton:ClearAllAnchors()
            ad.miniButton:SetAnchor(pnt, relPnt, frame, x - width, y)
        end
    end
    if AddonManager_Settings.AutoHideMiniBar then
        AddonManager.MinimizeMiniBar()
    end
end

AddonManager.ShowMiniButton = function(addon)
    local miniButton = addon.miniButton
    if not miniButton then
        return
    end
    
    local width = miniButton:GetWidth()
    local xPos = miniButton:GetPos()
    if not AddonManager.AutoHideMiniBar then
        miniButton:Show()
    end
    AddonManagerMiniFrame:SetWidth(AddonManagerMiniFrame:GetWidth() + width)
    
    for i, ad in ipairs(AddonManager.Addons) do
        if ad.miniButton and ad ~= addon and ad.miniButton:GetPos() >= xPos then
            local pnt, relPnt, frame, x, y = ad.miniButton:GetAnchor()
            ad.miniButton:ClearAllAnchors()
            ad.miniButton:SetAnchor(pnt, relPnt, frame, x + width, y)
        end
    end
    if AddonManager_Settings.AutoHideMiniBar then
        AddonManager.MinimizeMiniBar()
    end
end

AddonManager.MiniButton_OnEnter = function(btn)
    if not btn.addon then
        return
    end
    if AddonManager_Settings.ShowOnlyNamesInMiniBar then
        GameTooltip:SetOwner(btn, "ANCHOR_TOPLEFT", 0, 0)
        GameTooltip:SetText(btn.addon.name, 1, 1, 1)
        GameTooltip:Show()
    else
        AddonManager.OnAddonEntered(btn)
    end
    
    if AddonManager_Settings.AutoHideMiniBar then
        AddonManager.RestoreMiniBar()
    end
end

AddonManager.MiniButton_OnLeave = function(btn)
    GameTooltip:Hide()
    
    if AddonManager_Settings.AutoHideMiniBar then
        AddonManager.MinimizeMiniBar()
    end
end

AddonManager.MiniButton_OnClick = function(btn)
    if btn.addon.onClickScript then
        btn.addon.onClickScript(btn, id)
        
    elseif Sol.util.IsValidFrame(btn.addon.configFrame) then
        ToggleUIFrame(btn.addon.configFrame)
    end
    GameTooltip:Hide()
end

AddonManager.SaveMiniPos = function()
    if AddonManager_Settings then
        AddonManager_Settings.MiniX, AddonManager_Settings.MiniY = AddonManagerMiniFrame:GetPos()
    end
end

AddonManager.ShowOrHideMiniBar = function(show)
    Sol.util.SetVisible(AddonManagerMiniFrame, show)
    for i, addon in ipairs(AddonManager.Addons) do
        if Sol.util.IsValidFrame(addon.miniButton) then
            local showThis = show and not Sol.table.Contains(AddonManager_UncheckedAddons, addon.name)
            Sol.util.SetVisible(addon.miniButton, showThis)
        end
    end
--~     
--~     if show then
--~         AddonManager.FixOverlaps()
--~     end
end

--~ AddonManager.FixOverlaps = function()
--~     local bounds = {}
--~     local count = 1
--~     for i = 1, #AddonManager.Addons do
--~         local addon = AddonManager.Addons[i]
--~         if addon.miniButton then
--~             local xPos = addon.miniButton:GetPos()
--~             local width = addon.miniButton:GetWidth()
--~             bounds[count] = { button=addon.miniButton, start=xPos, end=xPos+width }
--~             count = count + 1
--~         end
--~     end
--~     
--~     local sortFn = function(addonA, addonB)
--~         return addonA.start < addonB.start
--~     end
--~     table.sort(bounds, sortFn)
--~     
--~     for i = 1, #bounds do
--~         
--~     end
--~ end

AddonManager.MinimizeMiniBar = function()
	AddonManager.ShowOrHideMiniBar(false)
	AddonManagerMiniFrame:Show()
	AddonManagerMiniButton:Show()
	AddonManagerMiniFrame:SetSize(42, 34)
end

AddonManager.RestoreMiniBar = function()
	AddonManager.ShowOrHideMiniBar(true)
	AddonManagerMiniFrame:SetSize(AddonManager.GetMiniBarWidth(), 34)
end

AddonManager.GetMiniBarWidth = function()
	local width = 18
	for _, addon in pairs(AddonManager.Addons) do
		if addon.miniButton 
            and not Sol.table.Contains(AddonManager_UncheckedAddons, addon.name) then
			width = width + addon.miniButton:GetWidth()
		end
	end
	return width
end
